package com.rocogz.syy.order.entity.evaluate;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.evaluate.EvaluatedOrderDto;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 订单评价 主信息
 * </p>
 * @author zhangmin
 * @since 2020-04-20
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderEvaluate extends BaseEvaluate {

    /**
     * 用户可见
     */
    public static final int USER_VISIBLE = 1;

    /**
     * 用户不可见
     */
    public static final int USER_INVISIBLE = 2;

    /**
     * 已被逻辑删除
     */
    public static final int DELETED = 3;

    /**
     * 会员编码
     */
    private String userCode;

    /**
     * 评价内容
     */
    private String content;

    /**
     * 总评分 0.5-5
     */
    private BigDecimal score;


    /**
     * 来源: 自动评价 或 会员评价
     * @see OrderConstant.DictEvaluationOrigin
     */
    private String origin;

    /**
     * 是否匿名评价
     */
    private Boolean anonymous;

    /**
     * 1: 前端可见【默认】 2: 管理员设置为前端不可见  3:被逻辑删除
     */
    private Integer visible;

    /**
     * 是否精选
     */
    private Boolean perfect;

    /**
     * 评价人名字
     */
    private String createUser;

    /**
     * 更新人名字
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 印象标签
     */
    @TableField(exist = false)
    private List<EvaluateImpression> impressionList;

    /**
     * 服务指标kpi列表
     */
    @TableField(exist = false)
    private List<EvaluateKpi> kpiList;

    /**
     * 评价上传的图片
     */
    @TableField(exist = false)
    private List<EvaluateAttach> attachList;


    //被评价的订单信息dto,后台订单搜索使用
    private transient EvaluatedOrderDto orderDto;


    public boolean isDeleted() {
        return visible!=null && DELETED == visible;
    }

    public String getVisibleLabel() {
        if(visible == null) {
            return StringUtils.EMPTY;
        }
        switch (visible) {
            case USER_VISIBLE:
                return "显示";
            case USER_INVISIBLE:
                return "隐藏";
            case DELETED:
                return "已删除";
        }
        return StringUtils.EMPTY;
    }

}
