package com.rocogz.syy.order.dto.goods;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.OrderCentPayDto;
import com.rocogz.syy.order.dto.withdrawals.CreateWithdrawalsOrderDto;
import com.rocogz.syy.order.entity.goods.GoodsOrderAgentUserInfo;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 创建商品订单 Dto
 * @author ranxiangfu
 * @date 2020/8/19
 */
@Data
@Accessors(chain = true)
public class CreateGoodsOrderDto {

    /**
     * 订单编号 [如果是外部生成订单编号，则传入此参数]
     */
    private String orderCode;

    /**
     * 会员编号 [必传]
     */
    private String userCode;

    /**
     * 会员手机号 [必传]
     */
    private String mobile;

    /**
     * 会员openid [必传]
     */
    private String openId;

    /**
     * 下单来源平台编号，如：syy  [必传]
     * @see OrderConstant#DICT_PLATFORM_CODE_CAR_SERVICE
     */
    @NotEmpty
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.DictChannel
     */
    @NotEmpty
    private String channel;

    /*
     * 所属平台appId
     */
    private String miniAppid;

    /**
     * 是否虚拟商品
     */
    @NotNull
    private Boolean virtualGoods;

    /**
     * 商品编号
     */
    @NotEmpty
    private String goodsCode;

    /**
     * 商品供应商编号
     */
    @NotEmpty
    private String goodsSupplierCode;

    /**
     * 商品供应商名称
     */
    @NotEmpty
    private String goodsSupplierName;

    /**
     * 商品名称
     */
    @NotEmpty
    private String goodsName;

    /**
     * 商品展示图片url
     */
    private String goodsPictureUrl;

    /**
     * 商品单价
     */
    @NotNull
    private BigDecimal goodsUnitPrice;

    /**
     * 商品购买数量
     */
    @NotNull
    private Integer goodsAmount;

    /**
     * 支付方式(POINT:积分; CASH:现金;POINT_AND_CASH:积分+现金)
     */
    @NotNull
    private String payWay;

    /**
     * 商品总价
     */
    @NotNull
    private BigDecimal goodsTotalPrice;

    /**
     * 订单总金额(含运费)
     */
    @NotNull
    private BigDecimal totalAmount;

    /**
     * 订单总金额(含运费)
     */
    @NotNull
    private BigDecimal pointPayedTotalAmount;

    /**
     * 快递运输费用
     */
    @NotNull
    private BigDecimal transportFeeAmount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 收货人手机号
     */
    private String deliveryMobile;

    /**
     * 收货人
     */
    private String addressee;

    /**
     * 地址-省份
     */
    private String addressProvince;

    /**
     * 地址-城市
     */
    private String addressCity;

    /**
     * 地址-区/县
     */
    private String addressDistrict;

    /**
     * 地址-街道门牌号等信息
     */
    private String addressStreet;

    /**
     * 完整地址
     */
    private String fullAddress;

    /**
     * 标签名称
     */
    private String labelName;

    /**
     * 积分支付信息
     */
    private OrderCentPayDto orderCentPayDto;

    /**
     * 是否是权益转赠的商品订单
     */
    private Boolean bestow = false;

    /**
     * 是否是来自投保礼的权益转赠的商品订单(没有支付信息,直接是待领取状态)
     */
    private Boolean insuranceGift = false;

    /**
     * 赠送记录编码
     */
    private String bestowCode;

    /**
     * 赠送记录-赠送人的手机号
     */
    private String senderMobile;

    /**
     * 赠送记录-接受人的手机号
     */
    private String receiverMobile;

    /**
     * 会员编号 [必传]
     */
    private String createUserCode;

    /**
     * 下单类型
     */
    private String createType;

    /**
     * 商品订单B端代理人信息
     */
    private GoodsOrderAgentUserInfo goodsOrderAgentUserInfo;

    /**
     * 积分兑换产品编码
     */
    private String pointExchangeProductCode;

    /**
     * 积分兑换产品名称
     */
    private String pointExchangeProductName;

    /**
     * 平台产品类型
     */
    private String productType;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 油卡充值手机号码
     */
    private String oilRechargeMobile;

    /**
     * 代理商产品-市场价(油卡直冲时是到账金额)
     */
    private BigDecimal agentProductMarketPrice;

    /**
     * 代理商产品-采购价
     */
    private BigDecimal agentProductPurchasePrice;

    /**
     * 是否是来自活动弹窗创建的订单.
     */
    private Boolean createFromAlter;
}

