package com.rocogz.syy.order.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Splitter;
import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 后台管理订单 搜索
 * @author zhangmin
 * @date 2020/6/15
 */
@Data
public abstract class AdminBaseSearchDto {

    public static final String SPLITER = ",";

    private Boolean export = Boolean.FALSE;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 销售渠道
     * @see OrderConstant.DictChannel
     */
    private String channel;

    /**
     * 订单来源平台码
     */
    private String platformCode;

    /**
     * 会员编号
     */
    private String userCode;

    /**
     * 会员openid
     */
    private String userOpenid;

    /**
     * 会员手机号
     */
    private String userMobile;

    /**
     * 订单核销码
     */
    private String writeOffCode;

    /**
     * 订单状态
     */
    private String status;

    /**
     * 下单时间
     */
    private String createStartTime;

    private String createEndTime;


    /**
     * 专区编号,多个用逗号分开
     */
    private String areaCodes;

    /**
     * 门店编号,多个用逗号分开
     */
    private String storeCodes;

    /**
     * 所属平台appIds
     */
    private String miniAppids;

    /**
     * 代理商编号
     */
    private String agentCodes;

    /**
     * 合作客户编号
     */
    private String customerCodes;

    /**
     * 发放主体编号
     */
    private String issuingBodyCodes;

    /**
     * 团队编号
     */
    private String teamCodes;


    /**
     * 结算商编码列表
     */
    private List<String> settleSubjectCodeList;

    /**
     * 使用时间
     */
    private String usedStartTime;
    private String usedEndTime;

    /**
     * 业务类型（交互上叫: 发券性质）
     * 2021-01-19 ranxiangfu
     */
    private String serviceType;

    /**
     * 订单编号列表
     */
    private List<String> orderCodeList;

    @JsonIgnore
    public List<String> getAreaCodeList() {
        if(StringUtils.isBlank(this.areaCodes)) {
            return null;
        }

        return Splitter.on(SPLITER).splitToList(areaCodes);
    }

    @JsonIgnore
    public List<String> getStoreCodeList() {
        if(StringUtils.isBlank(this.storeCodes)) {
            return null;
        }
        return Splitter.on(SPLITER).splitToList(storeCodes);
    }


    @JsonIgnore
    public List<String> getMiniAppidList() {
        if(StringUtils.isBlank(this.miniAppids)) {
            return null;
        }
        return Splitter.on(SPLITER).splitToList(miniAppids);
    }


    @JsonIgnore
    public List<String> getAgentCodeList() {
        if(StringUtils.isBlank(this.agentCodes)) {
            return null;
        }
        return Splitter.on(SPLITER).splitToList(agentCodes);
    }

    @JsonIgnore
    public List<String> getCustomerCodeList() {
        if(StringUtils.isBlank(this.customerCodes)) {
            return null;
        }
        return Splitter.on(SPLITER).splitToList(customerCodes);
    }

    @JsonIgnore
    public List<String> getIssuingBodyCodeList() {
        if(StringUtils.isBlank(this.issuingBodyCodes)) {
            return null;
        }
        return Splitter.on(SPLITER).splitToList(issuingBodyCodes);
    }

    @JsonIgnore
    public List<String> getTeamCodeList() {
        if(StringUtils.isBlank(this.teamCodes)) {
            return null;
        }
        return Splitter.on(SPLITER).splitToList(teamCodes);
    }


    private Integer limit = 20;

    private Integer page = 1;

}
