package com.rocogz.syy.order.dto;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author zhangmin
 * @date 2020/4/28
 * 订单核销->优惠券信息
 */
@Setter @Getter
public class OrderCouponDto {

    /**
     * 优惠券编码
     */
    private String couponCode;

    /**
     * 优惠券名称
     */
    private String couponName;

    /**
     * 优惠券状态（草稿、待审批、审批通过、审批不通过、审批打回、待上架、上架、下架）
     */
    private String status;

    /**
     * 专区服务项目编号
     */
    private String areaServiceCode;

    /**
     * 商户服务项目编号
     */
    private String serviceProjectCode;

    /**
     * 活动编号
     */
    private String activityCode;

    /**
     * 所属平台appIds
     */
    private String miniAppid;

    /**
     * 专区可用范围：POINT_AREA(指定专区)、 所有专区(ALL)
     */
    private String areaUseRange;

    /**
     *  门店使用范围：指定门店(POINT_STORE)、所有门店（ALL）（若选择所有门店则可以指定哪些门店不可用）
     */
    private String storeUseRange;


    /**
     * 可用专区或排除的专区编号List
     */
    private List<String> areaCodeList;

    /**
     * 可用门店或排除的门店编号List
     */
    private List<String> storeCodeList;

    /**
     * 标签列表
     */
    private List<String> labelCodeList;


}
