package com.rocogz.syy.order.dto.jms;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 代金券+现金支付的油卡订单，我们这边支付成功后到油卡系统创建充值订单
 */
@Setter
@Getter
@ToString
@JsonIgnoreProperties(ignoreUnknown = true)
public class CreateDingJuOilOrderMsg {

    /**
     * 权益编号【必须】
     */
    private String pwNo;

    /**
     * 手机号,即充值手机号【必须】
     */
    private String phone;

    /**
     * 商户订单号，即roco车服订单号【必须】
     */
    private String outOrderId;

    /**
     * 充值面额,充值金额【必须】
     */
    private Integer itemFacePrice;

    /**
     * 微信流水号[微信支付流水号] 【必须】
     */
    private String wxTradeNo;

    /**
     * 微信支付金额 【必须】
     */
    private String wxPayAmount;


}
