package com.rocogz.syy.order.entity.goods;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单中心-商品订单积分回馈
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-10-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_goods_order_point_feedback")
public class GoodsOrderPointFeedback extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 积分回馈编码
     */
    private String code;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 用户openid
     */
    private String userOpenid;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单创建人用户编号
     */
    private String orderCreateUserCode;

    /**
     * 积分发放返回状态码
     */
    private String pointGrantResCode;

    /**
     * 积分发放返回信息
     */
    private String pointGrantResMsg;

    /**
     * 类型(SELF: 个人订单; MEMBER:团员订单)
     */
    private String type;

    /**
     * 订单现金支付总金额
     */
    private BigDecimal orderCashPayAmount;

    /**
     * 回馈比例
     */
    private BigDecimal feedbackRate;

    /**
     * 回馈的积分类型
     */
    private String pointType;

    /**
     * 回馈的积分数量
     */
    private BigDecimal pointAmount;

    /**
     * 积分编号
     */
    private String pointCode;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
