package com.rocogz.syy.order.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 商户投保礼礼品详情
 * </p>
 *
 * @author liangyongtong
 * @since 2020-08-31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "order_merchant_insurance_gift_item_detail")
public class MerchantInsuranceGiftItemDetail extends IdEntity {

    private static final long serialVersionUID = 862180015168437208L;
    /**
     * 主订单编号 -> 投保方案编号
     */
    private String mainCode;

    /**
     * 二级订单号
     */
    private String itemCode;

    /**
     * 关联礼品编码
     */
    private String giftCode;

    /**
     * 关联类型:(套餐|项目|礼品|加油代金券 )
     */
    private String relateType;

    /**
     * 对应的关联数据编码
     */
    private String relateCode;

    /**
     * 对应的关联数据名称
     */
    private String relateName;

    /**
     * 数量
     */
    private Integer amount;

    /**
     * 成本价
     */
    private BigDecimal costPrice;

    /**
     * 市场价
     */
    private BigDecimal marketPrice;

    /**
     * 销售价
     */
    private BigDecimal settlePrice;

    /**
     * 备付金金额
     */
    private BigDecimal coverSettlePrice;

    /**
     * 实体商品状态
     */
    private String entityGiftStatus;

    /**
     * 虚拟商品状态
     */
    private String virtualGiftStatus;

    /**
     * 图片路径
     */
    @TableField(exist = false)
    private String imageUrl;

    /**
     * 可用商品库存，返回详情的时候会使用到
     */
    @TableField(exist = false)
    private Integer goodsStock;

    /**
     * 商品亮点
     */
    @TableField(exist = false)
    private String saleLightPoint;

    /**
     * 使用条件
     */
    @TableField(exist = false)
    private String useCondition;
    @TableField(exist = false)
    private BigDecimal useLimit;
    @TableField(exist = false)
    private BigDecimal useLimitMax;
    @TableField(exist = false)
    private BigDecimal faceValue;


    /**
     * 套餐对应的项目列表
     */
    @TableField(exist = false)
    private List<MerchantInsuranceGiftItemDetailCombo> itemDetailCombos;
}
