package com.rocogz.syy.order.dto.inspection;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.Future;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author djt
 * @date 2021/1/21
 */
@Data
public class CarInspectionYearOrderCreateDTO {

    /**
     * 车牌号
     */
    @Length(max = 32)
    @NotBlank
    private String  plateNumber;

    /**
     * 车辆类型
     */
    @Length(max = 32)
    @NotBlank
    private String carType;

    /**
     * 车主姓名
     */
    @Length(max = 32)
    private String consignee;

    /**
     * 手机号
     */
    @Length(max = 32)
    @NotBlank
    private String phone;

    /**
     * 预约年检日期
     */
    @Future
    @NotNull
    private LocalDate appointTime;


    /**
     * 取车地址
     */
    private String carLocation;


    /**
     * 预约接车时间
     */
    private LocalDateTime carTime;

    /**
     * 自驾 self_diver_price  、third_diver_price 包车接送 ,vip_price 修复包过
     */
    @Pattern(regexp = "^(self_diver_price|third_diver_price|vip_price)$")
    @NotBlank
    private String inspectionYearMode;

    /**
     * 行驶证正面图片
     */
    private String vehicleDrivingLicenseFrontImage;

    /**
     * 行驶证反面图片
     */
    private String vehicleDrivingLicenseBackImage;

    /**
     * 检测站
     */
    private  CarCheckStation carCheckStation;
}
