package com.rocogz.syy.order.entity.insuranceGift;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 开单礼赠赠送失败
 * </p>
 *
 * @author liangyongtong
 * @since 2020-11-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "order_merchant_insurance_gift_fail")
public class MerchantInsuranceGiftFail extends IdEntity {

    private static final long serialVersionUID = 8725694484920727920L;
    /**
     * 主订单编号 -> 投保方案编号
     */
    private String mainCode;

    /**
     * 二级订单编码（主订单编码 + hhmmss）
     */
    private String itemCode;

    /**
     * 订单类型
     */
    private String orderType;

    /**
     * 原因
     */
    private String reason;

    /**
     * 结果
     */
    private String result;

    /**
     * 时间
     */
    private LocalDateTime createTime;

}
