package com.rocogz.syy.order.entity.orders.club;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 会所订单明细表
 * zjk 2022-9-23 16:40:37
 */
@Setter
@Getter
@Accessors(chain = true)
public class OrderClubOrderItem extends IdEntity {

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单明细编码
     */
    private String code;

    /**
     * 商品编号
     */
    private String goodsCode;

    /**
     * 商品名称
     */
    @TableField(exist = false)
    private String goodsName;

    /**
     * 商品单价
     */
    private BigDecimal price;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 商品总价
     */
    private BigDecimal totalPrice;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

}
