package com.rocogz.syy.order.dto.pay;

import com.rocogz.syy.order.constant.trace.TradeTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

/**
 * <dl>
 * <dd>Description: 微信支付传参dto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/6/28 10:07</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Data
@Accessors(chain = true)
public class WxPayUnifiedOrderParamDto {

    //微信支付统一下单接口API文档： https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_1

    /**
     * 字段名：小程序appid.
     * 是否必填：是
     */
    @NotEmpty
    private String appid;

    /**
     * 字段名：收款商户id，为空时使用默认的收款商户.
     * 是否必填：否
     */
    private String mchId;

    /**
     * 字段名：订单类型.
     * 是否必填：是
     */
    @NotNull
    private TradeTypeEnum rocoTradeType;

    /**
     * <pre>
     * 字段名：附加数据.
     * 变量名：attach
     * 是否必填：否
     * 类型：String(127)
     * 示例值： 深圳分店
     * 描述：  附加数据，在查询API和支付通知中原样返回，该字段主要用于商户携带订单的自定义数据
     * </pre>
     */
    private String attach;

    /**
     * <pre>
     * 字段名：商户订单号.
     * 变量名：out_trade_no
     * 是否必填：是
     * 类型：String(32)
     * 示例值：20150806125346
     * 描述：商户系统内部的订单号,32个字符内、可包含字母
     * </pre>
     */
    @NotEmpty
    private String outTradeNo;


    /**
     * <pre>
     * 字段名：用户openid.
     * 是否必填：是
     * 描述：用户openid
     * </pre>
     */
    @NotEmpty
    private String openid;

    /**
     * <pre>
     * 字段名：商品描述.
     * 变量名：body
     * 是否必填：是
     * 类型：String(128)
     * 示例值： 腾讯充值中心-QQ会员充值
     * </pre>
     */
    @NotEmpty
    private String body;

    /**
     * <pre>
     * 字段名：通知地址.
     * 变量名：notify_url
     * 是否必填：否
     * 类型：String(256)
     * 示例值：http://www.weixin.qq.com/wxpay/pay.php
     * 描述：接收微信支付异步通知回调地址，通知url必须为直接可访问的url，不能携带参数。
     *      roco车服目前定的回调地址是统一的，如果需要另外的回调地址请传入此参数，否则不用传。
     * </pre>
     */
    private String notifyUrl;

    /**
     * <pre>
     * 字段名：总金额.
     * 变量名：total_fee
     * 是否必填：是
     * 类型：Int
     * 示例值： 888
     * 描述：订单总金额，单位为分，详见支付金额
     * </pre>
     */
    @NotNull
    private Integer totalFee;

    /**
     * <pre>
     * 字段名：订单失效时间.
     * 变量名：time_expire
     * 是否必填：否
     * 类型：String(14)
     * 示例值：20091227091010
     * 描述：订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。其他详见时间规则
     *   注意：最短失效时间间隔必须大于5分钟，默认为2小时
     * </pre>
     */
    private String timeExpire;
}
