package com.rocogz.syy.order.constant;

/**
 * 会所订单常量
 *
 * zjk 2022-9-23 16:48:01
 */
public class ClubOrderConstant {

    /**
     * 订单类型
     */
    public static final class DictClubOrderType {
        //字典类型编号
        public static final String TYPE_CODE = "CLUB_ORDER_TYPE";

        //=== 下面是字典值
        /**
         * 用餐订单
         */
        public static final String RESTAURANT_ORDER = "RESTAURANT_ORDER";
    }

    /**
     * 支付方式
     */
    public static final class DictClubPayType {
        //字典类型编号
        public static final String TYPE_CODE = "CLUB_PAY_TYPE";

        //=== 下面是字典值
        /**
         * 线下支付
         */
        public static final String OFFLINE_PAY = "OFFLINE_PAY";

        /**
         * 微信支付
         */
        public static final String WECHAT_PAY = "WECHAT_PAY";
    }

    /**
     * 订单状态状态
     */
    public static final class DictClubOrderStatus {
        //字典类型编号
        public static final String TYPE_CODE = "CLUB_ORDER_STATUS";

        //=== 下面是字典值

        //待支付
        public static final String PENDING_PAY = "PENDING_PAY";

        //已完成
        public static final String FINISHED = "FINISHED";

        //已取消
        public static final String CANCELED = "CANCELED";

        //用餐中
        public static final String AT_MEAL = "AT_MEAL";

    }

    /**
     * 订单状态操作
     */
    public static final class DictClubOrderAction {
        //字典类型编号
        public static final String TYPE_CODE = "CLUB_ORDER_ACTION";

        //=== 下面是字典值
        //创建订单
        public static final String CREATED = "CREATED";

        //加餐
        public static final String UPDATE = "UPDATE";

        //取消订单
        public static final String CANCEL = "CANCEL";

        //结账
        public static final String SETTLEMENT = "SETTLEMENT";

        //支付成功
        public static final String PAY = "PAY";

    }

}
