package com.rocogz.syy.order.dto;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.entity.evaluate.EvaluateAttach;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 描述：前端js传入 核销请求参数
 * @author zhangmin
 */
@Setter
@Getter
@Accessors(chain = true)
public class WriteOffUIParamDto {

    /**
     * 前端传入的核销码(扫码的核销码/用户输入的核销码) [必传]
     */
    private String writeOffCodeParam;

    /**
     * 商户服务项目 [必传]
     */
    private String storeServiceCode;

    /**
     * 专区编号，如果门店有多个专区，则核销时让用户选择专区 [admin 端核销专用]
     */
    private String areaCode;

    /**
     * 专区名称， 如果门店有多个专区，则核销时让用户选择专区[admin 端核销专用]
     */
    private String areaName;

    /**
     * 在B端小程序核销页面，填写的车牌号
     * 车牌号
     */
    private String license;

    /**
     * 在B端小程序核销页面，填写的车架号
     * 车架号
     */
    private String vinNo;

    /**
     * 核销时：填写的备注信息
     */
    private String remark;

    /**
     * 下单车辆类型
     * 车辆类型：CAR("小型车"),SUV ,MPV, OTHER("其他车型"),ALL("不区分车型")
     * basic_dict_data 表中 AREA_SERVICE_CAR_TYPE类型的字典数据
     */
    @Deprecated
    private String carType;

    /**
     * 核销方式 [必传]
     *
     * @see OrderConstant.DictWriteOffWay
     */
    private String writeOffWay;

    /**
     * 核销传入的图片
     */
    private List<EvaluateAttach> attachList;

    /**
     * 服务券系统使用的核销码, 调用方 要前端传入券的先处理成券系统格式的核销码
     * 前端传入格式：SF42A-1AB6-2BC8-1727
     * 券系统格式： F42A1AB62BC81727
     *
     * 预约订单核销码格式：
     */
    private String writeOffCode;

}
