package com.rocogz.syy.order.dto.inspection;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author djt
 * @date 2021/1/21
 */
@Data
public class CarInspectionCouponPayItemDTO {

    /**
     * 鼎聚权益编号
     */
    private String powerNo;

    /**
     * 用户券编号[必传]
     */
    @NotBlank
    private String userCouponCode;

    /**
     * 核销码 例如：F42A1AB62BC81727 [必传]
     */
    @NotBlank
    private String writeOffCode;

    /**
     * 该券 所支付的金额 [必传]
     */
    @NotNull
    private BigDecimal payAmt;

    /**
     * 支付方式
     */
    private String payWay;

}
