package com.rocogz.syy.order.entity.evaluate;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单附件 上传的图片
 * </p>
 *
 * @author zhangmin
 * @since 2020-05-20
 */
@Setter @Getter
@Accessors(chain = true)
@TableName("order_evaluate_attach")
public class EvaluateAttach extends IdEntity implements Comparable<EvaluateAttach> {

    /**
     * 评论图片 生成的缩略图 尺寸
     */
    public static final String THUMB_IMG_SIZE = "200_200";


    /**
     * 评价图片文件上传到阿里云oss中的目录
     */
    public static final String EVALUATION_IMG_DIR = "orderEvaluation";

    /**
     * 服务项目核销：订单核销图片
     */
    public static final String ORDER_WRITEOFF_IMG_DIR = "orderWriteOff";


    public EvaluateAttach() {
    }

    public EvaluateAttach(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 图片url
     * 例如：https://rocoautoser-uat.oss-cn-shenzhen.aliyuncs.com/orderEvaluation/20200624_78799c72e6d144febb175c7da1c5521f.jpg
     */
    private String imgUrl;

    /**
     * 图片顺序
     */
    private Integer seq;

    /**
     * 是否可见，默认可见
     */
    private Boolean visible;

    /**
     * 目标业务类型： orderEvaluation("订单评价图片"), orderWriteOff("订单核销图片")
     */
    private String targetType;

    /**
     * 上传的文件名：例如 宝马4s店.jpg
     */
    private String uploadName;

    /**
     * 文件说明
     */
    private String description;


    /**
     * 文件大小
     */
    private Integer fileSize;


    /**
     * 创建的用户 username
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 获得生成的小图 路径
     * http://www.xx.com/store/abc.jpg ==> http://www.xx.com/store/abc140_140.jpg
     */
    public String getThumbImgUrl() {
        if (StringUtils.isBlank(imgUrl)) {
            return null;
        }

        //http://www.xx.com/store/
        String path = FilenameUtils.getPath(imgUrl);
        //abc
        String baseName = FilenameUtils.getBaseName(imgUrl);
        //jpg
        String extName = FilenameUtils.getExtension(imgUrl);
        String thumbSize = THUMB_IMG_SIZE;
        String thumbImgUrl = path + baseName + thumbSize + "." + extName;
        return thumbImgUrl;
    }

    @Override
    public int compareTo(EvaluateAttach other) {
        return Integer.compare(seq, other.getSeq());
    }
}
