package com.rocogz.syy.order.entity.orders;

import com.rocogz.syy.common.annotation.UniqueField;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.util.ArithUtil;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * <p>
 * 订单结算信息
 * </p>
 *
 * @author zhangmin
 * @since 2020-04-26
 */
@Setter
@Getter
@Accessors(chain = true)
public class OrderSettlement extends IdEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 订单编号
     */
    @UniqueField
    private String orderCode;

    /**
     * 商户结算价,即结算商结算价,O2O项目的成本价
     * @see com.rocogz.merchant.entity.storeservice.MerchantStoreServicePrice#settlePrice
     */
    private BigDecimal storeSettlePrice;

    /**
     * 商户结算状态
     * @see OrderConstant.DictSettleStatus
     */
    private String storeSettleStatus;

    /**
     * @see com.rocogz.merchant.entity.storeservice.MerchantStoreServicePrice#marketPrice
     */
    private BigDecimal enterpriceSettlePrice;

    /**
     * 企业客户结算状态
     *
     * @see OrderConstant.DictSettleStatus
     */
    @Deprecated
    private String enterpriceSettleStatus;

    /**
     * 结算方主体编号
     */
    private String enterpriceCode;

    // 以下方便页面展示字段

    //结算方主体名称
    private transient String enterpriceName;
    private transient String enterpriceSettleStatusLabel;
    private transient String storeSettleStatusLabel;


    public String getFmtStoreSettlePrice() {
        if(storeSettlePrice == null) {
            return StringUtils.EMPTY;
        }

        return ArithUtil.getNoSymbolCurrency(storeSettlePrice.doubleValue());
    }


    @Deprecated
    public String getFmtEnterpriceSettlePrice() {
        if(enterpriceSettlePrice == null) {
            return StringUtils.EMPTY;
        }
        return ArithUtil.getNoSymbolCurrency(enterpriceSettlePrice.doubleValue());
    }

}
