/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.client;

import com.rocogz.syy.common.PageTable;
import com.rocogz.syy.common.response.Response;
import com.rocogz.syy.order.client.req.GiftLogQuery;
import com.rocogz.syy.order.constant.EvaluateStatisOption;
import com.rocogz.syy.order.constant.OrderStatisOption;
import com.rocogz.syy.order.constant.OtherInfoOption;
import com.rocogz.syy.order.constant.StatisTimeRangeEnum;
import com.rocogz.syy.order.constant.trace.BussiSystemEnum;
import com.rocogz.syy.order.constant.trace.BussiTypeEnum;
import com.rocogz.syy.order.constant.trace.CallApiEnum;
import com.rocogz.syy.order.dto.AdminSearchParamDto;
import com.rocogz.syy.order.dto.CancelOrderResultDto;
import com.rocogz.syy.order.dto.OrderCashPayDto;
import com.rocogz.syy.order.dto.OrderCentPayDto;
import com.rocogz.syy.order.dto.OrderCountParamDto;
import com.rocogz.syy.order.dto.OrderCountResultDto;
import com.rocogz.syy.order.dto.OrderCreateCentExchangeDto;
import com.rocogz.syy.order.dto.OrderSummaryStatistic;
import com.rocogz.syy.order.dto.OrderTeamAndOrgAndAgentDto;
import com.rocogz.syy.order.dto.OrderWriteOffDto;
import com.rocogz.syy.order.dto.appoint.AppointAdminSearchParamDto;
import com.rocogz.syy.order.dto.appoint.AppointWriteOffDto;
import com.rocogz.syy.order.dto.appoint.AppointWriteOffPreparedDataDto;
import com.rocogz.syy.order.dto.appoint.CreateAppointOrderDto;
import com.rocogz.syy.order.dto.club.ClubOrderParamsDTO;
import com.rocogz.syy.order.dto.evaluate.AdminSearchEvaluationParamDto;
import com.rocogz.syy.order.dto.evaluate.OrderEvaluateSummaryStatistic;
import com.rocogz.syy.order.dto.goods.CreateGoodsOrderDto;
import com.rocogz.syy.order.dto.goods.GoodsAdminSearchParamDto;
import com.rocogz.syy.order.dto.goods.GoodsOrderAutoReceiptDto;
import com.rocogz.syy.order.dto.goods.GoodsOrderChangeStatusDto;
import com.rocogz.syy.order.dto.goods.GoodsOrderExpressDeliveryInfoDto;
import com.rocogz.syy.order.dto.goods.GoodsOrderReceiveDto;
import com.rocogz.syy.order.dto.goods.PointFeedbackSummaryDto;
import com.rocogz.syy.order.dto.goods.UpdateGoodOrderShellOilStationDto;
import com.rocogz.syy.order.dto.inspection.CarInspectionAdminSearchParamsDTO;
import com.rocogz.syy.order.dto.inspection.CarInspectionOrderCreateDTO;
import com.rocogz.syy.order.dto.insurancegift.CopyGiftDto;
import com.rocogz.syy.order.dto.insurancegift.GiftCancelDto;
import com.rocogz.syy.order.dto.insurancegift.GiftStatusUpdateDto;
import com.rocogz.syy.order.dto.insurancegift.GiftSummaryDto;
import com.rocogz.syy.order.dto.insurancegift.MerchantInsuranceGifOrderPayDto;
import com.rocogz.syy.order.dto.insurancegift.MerchantInsuranceGiftItemOrderDetailDTO;
import com.rocogz.syy.order.dto.insurancegift.MerchantInsuranceGiftItemOrderDetailInfoAdminDto;
import com.rocogz.syy.order.dto.insurancegift.MerchantInsuranceGiftMainOrderAdminDto;
import com.rocogz.syy.order.dto.insurancegift.MerchantInsuranceGiftMainOrderAdminPageDto;
import com.rocogz.syy.order.dto.insurancegift.MerchantInsuranceGiftOrderDto;
import com.rocogz.syy.order.dto.insurancegift.MerchantInsuranceGiftOrderPaymentDTO;
import com.rocogz.syy.order.dto.oil.DepositSummaryStatistic;
import com.rocogz.syy.order.dto.oil.OilAdminSearchParamDto;
import com.rocogz.syy.order.dto.oil.OilOrderCreateDto;
import com.rocogz.syy.order.dto.oil.OilOrderPayDto;
import com.rocogz.syy.order.dto.oil.OilOrderPayedResultDto;
import com.rocogz.syy.order.dto.oil.OilOrderWithCashCreateDto;
import com.rocogz.syy.order.dto.oil.OilTicketExchangeDetailDto;
import com.rocogz.syy.order.dto.pay.OrderPayDetailDto;
import com.rocogz.syy.order.dto.pay.WxPayRefundParamDto;
import com.rocogz.syy.order.dto.pay.WxPayUnifiedOrderParamDto;
import com.rocogz.syy.order.dto.pay.WxPayUnifiedOrderResultDto;
import com.rocogz.syy.order.dto.peccancy.CreatePeccancyOrderDto;
import com.rocogz.syy.order.dto.peccancy.PeccancyAdminSearchParamDto;
import com.rocogz.syy.order.dto.peccancy.PeccancyRecordTotalDto;
import com.rocogz.syy.order.dto.peccancy.QueryPeccancyConditionsDto;
import com.rocogz.syy.order.dto.trace.ApiRequestLogStatisticsResponseDto;
import com.rocogz.syy.order.dto.withdrawals.CreateWithdrawalsOrderDto;
import com.rocogz.syy.order.dto.withdrawals.WithdrawalsAdminSearchParamDto;
import com.rocogz.syy.order.dto.withdrawals.WithdrawalsFeeRatePageQueryDto;
import com.rocogz.syy.order.dto.withdrawals.WithdrawalsOrderChangeStatusDto;
import com.rocogz.syy.order.dto.withdrawals.WithdrawalsSummaryResultDto;
import com.rocogz.syy.order.entity.evaluate.OrderEvaluate;
import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.goods.GoodsOrderBestowInfo;
import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import com.rocogz.syy.order.entity.goods.GoodsOrderPointFeedback;
import com.rocogz.syy.order.entity.inspection.CarInspectionOrder;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftFail;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftItemDetail;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftItemOrder;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftLog;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftMainOrder;
import com.rocogz.syy.order.entity.oil.OilDepositRecord;
import com.rocogz.syy.order.entity.oil.OrderOilDeposit;
import com.rocogz.syy.order.entity.orders.OrderLog;
import com.rocogz.syy.order.entity.orders.OrderPayment;
import com.rocogz.syy.order.entity.orders.OrderPaymentRecord;
import com.rocogz.syy.order.entity.orders.SaleOrder;
import com.rocogz.syy.order.entity.orders.club.OrderClubOrder;
import com.rocogz.syy.order.entity.orders.club.OrderClubOrderRemark;
import com.rocogz.syy.order.entity.pay.OrderWxPayPaymentFlow;
import com.rocogz.syy.order.entity.pay.WxPayRecord;
import com.rocogz.syy.order.entity.pay.WxPayRefundRecord;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrder;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyQueryRecord;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyRecord;
import com.rocogz.syy.order.entity.trace.OrderErrorTrace;
import com.rocogz.syy.order.entity.trace.OrderThirdTrace;
import com.rocogz.syy.order.entity.withdrawals.OrderWithdrawalsRecordModifyLog;
import com.rocogz.syy.order.entity.withdrawals.WithdrawalsFeeRateConfig;
import com.rocogz.syy.order.entity.withdrawals.WithdrawalsFeeRateConfigLog;
import com.rocogz.syy.order.entity.withdrawals.WithdrawalsRecord;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface IOrderClientService {
    @GetMapping(value={"/order/paymentRecord/listByOrderCode"})
    public List<OrderPaymentRecord> listOrderPaymentRecordByOrderCode(@RequestParam(value="orderCode") String var1);

    @GetMapping(value={"/order/paymentRecord/listByOrderCodeAndPayWay"})
    public List<OrderPaymentRecord> listOrderPaymentRecordByOrderCodeAndPayWay(@RequestParam(value="orderCode") String var1, @RequestParam(value="payWay", required=false) String var2);

    @PostMapping(value={"/api/order/create"})
    public Response createOrder(@RequestBody SaleOrder var1);

    @GetMapping(value={"/api/order/adminSearch"})
    public PageTable<SaleOrder> adminSearch(@SpringQueryMap AdminSearchParamDto var1);

    @GetMapping(value={"/api/order/getOrderMainInfo/{orderCode}"})
    public Response<SaleOrder> getOrderMainInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/getOrderWithOtherInfo/{orderCode}"})
    public Response<SaleOrder> getOrderWithOtherInfo(@PathVariable(value="orderCode") String var1, @RequestParam(value="otherInfoList") List<OtherInfoOption> var2);

    @GetMapping(value={"/api/order/getOrderWithOtherByIdentifyCode/{identifyCode}"})
    public Response<SaleOrder> getOrderWithOtherByIdentifyCode(@PathVariable(value="identifyCode") String var1, @RequestParam(value="otherInfoList") List<OtherInfoOption> var2);

    @GetMapping(value={"/api/order/weappSearch"})
    public PageTable<SaleOrder> weappSearch(@RequestParam(value="userCode") String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="orderTypeList", required=false) List<String> var3, @RequestParam(value="limit", defaultValue="10") Integer var4, @RequestParam(value="page", defaultValue="1") Integer var5);

    @GetMapping(value={"/api/order/merchantWeappSearch"})
    public PageTable<SaleOrder> merchantWeappSearch(@RequestParam(value="storeCode") String var1, @RequestParam(value="keyword", required=false) String var2, @RequestParam(value="orderTypeList", required=false) List<String> var3, @RequestParam(value="statusList", required=false) List<String> var4, @RequestParam(value="appointStartTime", required=false) String var5, @RequestParam(value="appointEndTime", required=false) String var6, @RequestParam(value="limit", defaultValue="10") Integer var7, @RequestParam(value="page", defaultValue="1") Integer var8);

    @GetMapping(value={"/api/order/delete/{orderCode}"})
    public Response<String> deleteLogical(@PathVariable(value="orderCode") String var1, @RequestParam(value="userCode", required=false) String var2);

    @GetMapping(value={"/api/order/cancelOrder/{orderCode}"})
    public Response<CancelOrderResultDto> cancelOrder(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/adminCancelOrder/{orderCode}"})
    public Response<CancelOrderResultDto> adminCancelOrder(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser") String var2);

    @GetMapping(value={"/api/order/log/{orderCode}"})
    public Response<List<OrderLog>> findLogList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/scheduleExpireOrder"})
    public Response<String> scheduleExpireOrder();

    @GetMapping(value={"/api/order/scheduleFindCashPayTimeoutOrderCodes"})
    public Response<List<String>> scheduleFindCashPayTimeOutOrderCodes();

    @PostMapping(value={"/api/order/count"})
    public Response<List<OrderCountResultDto>> saleOrderCount(@RequestBody OrderCountParamDto var1);

    @PostMapping(value={"/api/order/listOrderWithOtherInfoByOrderCodes"})
    public Response<List<SaleOrder>> listOrderWithOtherInfoByOrderCodes(@RequestBody AdminSearchParamDto var1);

    @GetMapping(value={"/api/order/updateServiceTypeByOrderCode"})
    public Response updateServiceTypeByOrderCode(@RequestParam(value="orderCode") String var1, @RequestParam(value="serviceType") String var2);

    @GetMapping(value={"/api/order/statis/countGroupByStatus"})
    public Response<Map<String, Long>> countOrderNumGroupByStatus(@RequestParam(value="storeCode", required=false) String var1, @RequestParam(value="userCode", required=false) String var2);

    @PostMapping(value={"/api/order/statis/summarize"})
    public Response<Map<StatisTimeRangeEnum, OrderSummaryStatistic>> summarizeOrderByStoreCode(@RequestBody List<OrderStatisOption> var1);

    @GetMapping(value={"/api/order/statis/countNewest/{storeCode}"})
    public Response<Map<String, Long>> countNewestOrderByStoreCode(@PathVariable(value="storeCode") String var1);

    @PostMapping(value={"/api/order/writeOff/validateBeforeWriteOff"})
    public Response<String> validateBeforeWriteOff(@RequestBody OrderWriteOffDto var1);

    @PostMapping(value={"/api/order/writeOff/createOrder"})
    public Response<SaleOrder> createOrderWhenWriteOff(@RequestBody OrderWriteOffDto var1);

    @PostMapping(value={"/api/order/writeOff/updateOrderStatus"})
    public Response<String> updateStatusWithSaveLog(@RequestBody List<OrderLog> var1);

    @PostMapping(value={"/api/order/centExchange/createCentExchangeOrder"})
    public Response<SaleOrder> createCentExchangeOrder(@RequestBody OrderCreateCentExchangeDto var1);

    @PostMapping(value={"/api/order/centExchange/payCentExchangeOrder"})
    public Response payCentExchangeOrder(@RequestBody OrderCentPayDto var1);

    @PostMapping(value={"/api/order/evaluate/create"})
    public Response<OrderEvaluate> createEvaluate(@RequestBody OrderEvaluate var1);

    @GetMapping(value={"/api/order/evaluate/{orderCode}"})
    public Response<OrderEvaluate> getEvaluateByOrderCode(@PathVariable(value="orderCode") String var1, @RequestParam(value="loadOtherFlag", required=false) Integer var2);

    @GetMapping(value={"/api/order/evaluate/delete/{orderCode}"})
    public Response<String> deleteEvaluate(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/togglePerfect/{orderCode}"})
    public Response<String> toggleEvaluatePerfect(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/toggleVisibility/{orderCode}"})
    public Response<String> toggleEvaluateVisibility(@PathVariable(value="orderCode") String var1, @RequestParam(value="updateUser", required=false) String var2);

    @GetMapping(value={"/api/order/evaluate/adminSearch"})
    public PageTable<OrderEvaluate> adminSearchEvaluation(@SpringQueryMap AdminSearchEvaluationParamDto var1);

    @GetMapping(value={"/api/order/evaluate/weappSearch"})
    public PageTable<OrderEvaluate> weappSearchEvaluation(@RequestParam(value="code", required=false) String var1, @RequestParam(value="statisWay", required=false) EvaluateStatisOption.EvaluateStatisWay var2, @RequestParam(value="visible", required=false) Boolean var3, @RequestParam(value="perfect", required=false) Boolean var4, @RequestParam(value="impressionLabel", required=false) String var5, @RequestParam(value="limit", defaultValue="20") int var6, @RequestParam(value="page", defaultValue="1") int var7);

    @GetMapping(value={"/api/order/evaluate/weappSearchCount"})
    public Response<Integer> weappSearchCountEvaluation(@RequestParam(value="code", required=false) String var1, @RequestParam(value="statisWay", required=false) EvaluateStatisOption.EvaluateStatisWay var2, @RequestParam(value="visible", required=false) Boolean var3, @RequestParam(value="perfect", required=false) Boolean var4, @RequestParam(value="impressionLabel", required=false) String var5);

    @PostMapping(value={"/api/order/evaluate/statis/summarize"})
    public Response<Map<String, OrderEvaluateSummaryStatistic>> summarizeEvaluation(@RequestBody List<EvaluateStatisOption> var1);

    @PostMapping(value={"/api/order/oil/createOrder"})
    public Response<SaleOrder> createOilTicketOrder(@RequestBody OilOrderCreateDto var1);

    @PostMapping(value={"/api/order/oil/createWithCashOrder"})
    public Response<SaleOrder> createWithCashOilTicketOrder(@RequestBody OilOrderWithCashCreateDto var1);

    @PostMapping(value={"/api/order/oil/payOrder"})
    public Response<OilOrderPayedResultDto> payOilTicketOrder(@RequestBody OilOrderPayDto var1);

    @PostMapping(value={"/api/order/oil/cashPayOrder"})
    public Response payOilTickOrderByCash(@RequestBody OrderCashPayDto var1);

    @GetMapping(value={"/api/order/oil/manualCreateOilTrade/{orderCode}"})
    public Response<String> manualIssueCreateOilTrade(@PathVariable(value="orderCode") String var1);

    @PostMapping(value={"/api/order/oil/deposit/updateDepositOrder"})
    public Response<String> updateDepositWhenOilCreatedOrder(@RequestParam(value="orderCode") String var1, @RequestParam(value="tradeNo") String var2);

    @GetMapping(value={"/api/order/oil/deposit/findPendingRetryDeposit"})
    public Response<List<OrderOilDeposit>> findPendingRetryDeposit();

    @GetMapping(value={"/api/order/oil/deposit/getDepositOrderDetail/{tradeNo}"})
    public Response<OrderOilDeposit> getDepositOrderDetailByTradeNo(@PathVariable(value="tradeNo") String var1, @RequestParam(value="isLoadRecords", required=false) boolean var2);

    @PostMapping(value={"/api/order/oil/deposit/updateRetryTimes"})
    public Response<String> updateRetryTimesAndReason(@RequestBody OrderOilDeposit var1);

    @GetMapping(value={"/api/order/oil/deposit/exchangeDetail/{userCouponCode}"})
    public Response<OilTicketExchangeDetailDto> getExchangeDetail(@PathVariable(value="userCouponCode") String var1);

    @PostMapping(value={"/api/order/oil/depositRecord/save"})
    public Response<OilDepositRecord> saveDepositRecord(@RequestBody OilDepositRecord var1);

    @GetMapping(value={"/api/order/oil/depositRecord/manualResendExchangeMsg/{orderCode}"})
    public Response<String> manualResendExchangeMsg(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/depositRecord/weappSearch"})
    public PageTable<OilDepositRecord> weappSearchDepositRecord(@RequestParam(value="userCode", required=true) String var1, @RequestParam(value="orderCode", required=false) String var2, @RequestParam(value="depositMobile", required=false) String var3, @RequestParam(value="limit", defaultValue="20") int var4, @RequestParam(value="page", defaultValue="1") int var5);

    @GetMapping(value={"/api/order/oil/depositRecord/summarize"})
    public Response<DepositSummaryStatistic> summarizeDeposit(@RequestParam(value="userCode", required=true) String var1, @RequestParam(value="orderCode", required=false) String var2, @RequestParam(value="depositMobile", required=false) String var3);

    @GetMapping(value={"/api/order/oil/adminSearch"})
    public PageTable<SaleOrder> adminOilOrderSearch(@SpringQueryMap OilAdminSearchParamDto var1);

    @GetMapping(value={"/api/order/oil/getOrderOilPaymentInfo/{orderCode}"})
    public Response<OrderPayment> getOrderOilPaymentInfo(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/getOrderOilPaymentLogList/{orderCode}"})
    public Response<OrderPayment> getOrderOilPaymentLogList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/getOilDepositRecordList/{orderCode}"})
    public Response<List<OilDepositRecord>> getOilDepositRecordList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/oil/getPayDetailList/{orderCode}"})
    public Response<List<OrderPayDetailDto>> getPayDetailList(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/appoint/countAppintNum"})
    public Response<Map<String, Integer>> countAppintNum(@RequestParam(value="storeServiceCode") String var1, @RequestParam(value="timeRangeList") List<String> var2);

    @GetMapping(value={"/api/order/appoint/getAppointedNum"})
    public Response<Integer> getAppointedNum(@RequestParam(value="storeServiceCode") String var1, @RequestParam(value="startTime") String var2, @RequestParam(value="endTime") String var3);

    @GetMapping(value={"/api/order/appoint/updateAppointUserInfo"})
    public Response<String> updateUserInfoByAppoitMobileWhenBound(@RequestParam(value="userCode") String var1, @RequestParam(value="openId") String var2, @RequestParam(value="userMobile") String var3, @RequestParam(value="miniAppId") String var4);

    @PostMapping(value={"/api/order/appoint/createAppoint"})
    public Response<String> createAppointOrder(@RequestBody CreateAppointOrderDto var1);

    @GetMapping(value={"/api/order/appoint/prepareDataBeforeWriteOff/{thirdWriteOffCode}"})
    public Response<AppointWriteOffPreparedDataDto> prepareDataBeforeWriteOffAppointment(@PathVariable(value="thirdWriteOffCode") String var1);

    @PostMapping(value={"/api/order/appoint/doWriteOff"})
    public Response<SaleOrder> writeOffAppointOrder(@RequestBody AppointWriteOffDto var1);

    @GetMapping(value={"/api/order/appoint/internelCancelOrder/{orderCode}"})
    public Response<String> internelCancelAppointOrder(@PathVariable(value="orderCode") String var1, @RequestParam(value="actionUser", required=false) String var2, @RequestParam(value="channel") String var3);

    @GetMapping(value={"/api/order/appoint/externelCancelOrder/{thirdOrderCode}"})
    public Response<String> externelCancelAppointOrder(@PathVariable(value="thirdOrderCode") String var1, @RequestParam(value="thirdWriteOffCode") String var2);

    @GetMapping(value={"/api/order/appoint/adminSearch"})
    public PageTable<SaleOrder> adminSearchAppointOrder(@SpringQueryMap AppointAdminSearchParamDto var1);

    @PostMapping(value={"/api/order/peccancy/createPeccancyOrder"})
    public Response<SaleOrder> createPeccancyOrder(@RequestBody CreatePeccancyOrderDto var1);

    @PostMapping(value={"/api/order/peccancy/cashPayOrder"})
    public Response payPeccancyOrderByCash(@RequestBody OrderCashPayDto var1);

    @PostMapping(value={"/api/order/peccancy/update"})
    public Response<String> updatePeccancyByOrderCode(@RequestBody OrderPeccancyOrder var1);

    @GetMapping(value={"/api/order/peccancy/findPendingRetry"})
    public Response<List<OrderPeccancyOrder>> findPendingRetryPeccancyOrderList();

    @GetMapping(value={"/api/order/peccancy/adminSearch"})
    public PageTable<SaleOrder> adminSearchPeccancyOrder(@SpringQueryMap PeccancyAdminSearchParamDto var1);

    @GetMapping(value={"/api/order/peccancy/manualCreateDingJuOrder/{orderCode}"})
    public Response<String> manualIssueCreateDingJuOrder(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/trace/error"})
    public PageTable<OrderErrorTrace> searchErrorTrace(@RequestParam(value="coreCode", required=false) String var1, @RequestParam(value="bussType", required=false) BussiTypeEnum var2, @RequestParam(value="callApi", required=false) CallApiEnum var3, @RequestParam(value="system", required=false) BussiSystemEnum var4, @RequestParam(value="createStartTime", required=false) LocalDateTime var5, @RequestParam(value="createEndTime", required=false) LocalDateTime var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/order/trace/error/save"})
    public Response<String> saveErrorTrace(@RequestBody OrderErrorTrace var1);

    @GetMapping(value={"/api/order/trace/thirdApi"})
    public PageTable<OrderThirdTrace> searchThirdCallTrace(@RequestParam(value="coreCode", required=false) String var1, @RequestParam(value="callApiPath", required=false) String var2, @RequestParam(value="sourcePlatform", required=false) String var3, @RequestParam(value="targetPlatform", required=false) String var4, @RequestParam(value="createStartTime", required=false) LocalDateTime var5, @RequestParam(value="createEndTime", required=false) LocalDateTime var6, @RequestParam(value="limit", defaultValue="20") int var7, @RequestParam(value="page", defaultValue="1") int var8);

    @PostMapping(value={"/api/order/trace/thirdApi/save"})
    public Response<String> saveThirdCallTrace(@RequestBody OrderThirdTrace var1);

    @GetMapping(value={"/api/order/trace/thirdApi/pageQueryDistinctApiRequestInterface"})
    public PageTable<OrderThirdTrace> pageQueryDistinctApiRequestInterface(@RequestParam(value="callApiPath", required=false) String var1, @RequestParam(value="startTime") LocalDateTime var2, @RequestParam(value="endTime") LocalDateTime var3, @RequestParam(value="page", defaultValue="1") Integer var4, @RequestParam(value="limit", defaultValue="20") Integer var5);

    @GetMapping(value={"/api/order/trace/thirdApi/getStartTimeAndUsedTimeMillisList"})
    public Response<List<OrderThirdTrace>> getStartTimeAndUsedTimeMillisList(@RequestParam(value="callApiPath", required=false) String var1, @RequestParam(value="startTime") LocalDateTime var2, @RequestParam(value="endTime") LocalDateTime var3);

    @GetMapping(value={"/api/order/trace/thirdApi/statisticsMaxAndAverageUserTime"})
    public Response<ApiRequestLogStatisticsResponseDto> statisticsMaxAndAverageUserTimeApiList(@RequestParam(value="startTime") LocalDateTime var1, @RequestParam(value="endTime") LocalDateTime var2);

    @GetMapping(value={"/api/order/wx-pay-record/queryByRocoTradeNoAndStatus"})
    public Response<WxPayRecord> queryWxPayRecordByRocoTradeNoAndStatus(@RequestParam(value="rocoTradeNo") String var1, @RequestParam(value="wxTradeState", required=false) String var2);

    @GetMapping(value={"/api/order/wx-pay-record/queryByFlowCodeAndStatus"})
    public Response<WxPayRecord> queryWxPayRecordByFlowCodeAndStatus(@RequestParam(value="flowCode") String var1, @RequestParam(value="wxTradeState", required=false) String var2);

    @PostMapping(value={"/api/order/wx-pay-record/updateById"})
    public Response updateWxPayRecordById(@RequestBody WxPayRecord var1);

    @GetMapping(value={"/api/order/wx-pay-record/queryPage"})
    public PageTable<WxPayRecord> wxPayRecordPageTable(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="wxTransactionId", required=false) String var2, @RequestParam(value="wxUserOpenid", required=false) String var3, @RequestParam(value="rocoResCode", required=false) String var4, @RequestParam(value="rocoTradeType", required=false) String var5, @RequestParam(value="wxTradeState", required=false) String var6, @RequestParam(value="createTimeStart", required=false) String var7, @RequestParam(value="createTimeEnd", required=false) String var8, @RequestParam(value="wxTimeEndStart", required=false) String var9, @RequestParam(value="wxTimeEndEnd", required=false) String var10, @RequestParam(value="limit", defaultValue="20") int var11, @RequestParam(value="page", defaultValue="1") int var12);

    @GetMapping(value={"/api/order/wx-pay-record/wxPayRecordList"})
    public Response<List<WxPayRecord>> wxPayRecordList(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="wxTransactionId", required=false) String var2, @RequestParam(value="wxUserOpenid", required=false) String var3, @RequestParam(value="rocoResCode", required=false) String var4, @RequestParam(value="rocoTradeType", required=false) String var5, @RequestParam(value="wxTradeState", required=false) String var6, @RequestParam(value="createTimeStart", required=false) String var7, @RequestParam(value="createTimeEnd", required=false) String var8, @RequestParam(value="wxTimeEndStart", required=false) String var9, @RequestParam(value="wxTimeEndEnd", required=false) String var10);

    @GetMapping(value={"/api/order/wx-pay-record/getWxPayRecordByTradeNo"})
    public Response<WxPayRecord> getWxPayRecordByTradeNo(@RequestParam(value="rocoTradeNo") String var1);

    @GetMapping(value={"/api/order/wx-pay-record/getOrderWxPayPaymentFlow"})
    public Response<OrderWxPayPaymentFlow> getOrderWxPayPaymentFlow(@RequestParam(value="businessCode") String var1);

    @PostMapping(value={"/api/order/pay/wx/unifiedOrder"})
    public Response<WxPayUnifiedOrderResultDto> unifiedWxPayOrder(@RequestBody WxPayUnifiedOrderParamDto var1);

    @GetMapping(value={"/api/order/pay/wx/repayOrder"})
    public Response<WxPayUnifiedOrderResultDto> repayWxPayOrder(@RequestParam(value="outTradeNo") String var1);

    @GetMapping(value={"/api/order/pay/wx/closeOrder/{outTradeNo}"})
    public Response closeWxPayOrder(@PathVariable(value="outTradeNo") String var1);

    @PostMapping(value={"/api/order/pay/wx/refund"})
    public Response<String> refund(@RequestBody WxPayRefundParamDto var1);

    @GetMapping(value={"/api/order/wx-pay-refund-record/queryByRocoRefundNo"})
    public Response<WxPayRefundRecord> queryWxPayRefundRecordByRocoRefundNo(@RequestParam(value="rocoRefundNo") String var1);

    @PostMapping(value={"/api/order/wx-pay-refund-record/updateById"})
    public Response updateWxPayRefundRecordById(@RequestBody WxPayRefundRecord var1);

    @GetMapping(value={"/api/order/wx-pay-refund-record/queryPage"})
    public PageTable<WxPayRefundRecord> wxPayRefundRecordPageTable(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="rocoRefundNo", required=false) String var2, @RequestParam(value="wxRefundId", required=false) String var3, @RequestParam(value="wxTransactionId", required=false) String var4, @RequestParam(value="wxUserOpenid", required=false) String var5, @RequestParam(value="rocoResCode", required=false) String var6, @RequestParam(value="rocoTradeType", required=false) String var7, @RequestParam(value="wxRefundStatus", required=false) String var8, @RequestParam(value="wxRefundRequestSource", required=false) String var9, @RequestParam(value="createTimeStart", required=false) String var10, @RequestParam(value="createTimeEnd", required=false) String var11, @RequestParam(value="wxRefundSuccessTimeStart", required=false) String var12, @RequestParam(value="wxRefundSuccessTimeEnd", required=false) String var13, @RequestParam(value="limit", defaultValue="20") int var14, @RequestParam(value="page", defaultValue="1") int var15);

    @GetMapping(value={"/api/order/wx-pay-refund-record/wxPayRefundRecordList"})
    public Response<List<WxPayRefundRecord>> wxPayRefundRecordList(@RequestParam(value="rocoTradeNo", required=false) String var1, @RequestParam(value="rocoRefundNo", required=false) String var2, @RequestParam(value="wxRefundId", required=false) String var3, @RequestParam(value="wxTransactionId", required=false) String var4, @RequestParam(value="wxUserOpenid", required=false) String var5, @RequestParam(value="rocoResCode", required=false) String var6, @RequestParam(value="rocoTradeType", required=false) String var7, @RequestParam(value="wxRefundStatus", required=false) String var8, @RequestParam(value="wxRefundRequestSource", required=false) String var9, @RequestParam(value="createTimeStart", required=false) String var10, @RequestParam(value="createTimeEnd", required=false) String var11, @RequestParam(value="wxRefundSuccessTimeStart", required=false) String var12, @RequestParam(value="wxRefundSuccessTimeEnd", required=false) String var13);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyQueryRecord/lastest/query"})
    public Response<OrderPeccancyQueryRecord> lastestQuery(@RequestBody OrderPeccancyQueryRecord var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyQueryRecord/updatelastesttime"})
    public Response peccancyQueryRecordUpdateLastestTime(@RequestBody OrderPeccancyQueryRecord var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyRecord/list"})
    public Response peccancyRecord(@RequestBody List<OrderPeccancyRecord> var1);

    @GetMapping(value={"/api/order/peccancy/orderPeccancyQueryRecord/records"})
    public Response<List<OrderPeccancyQueryRecord>> queryPeccancyQueryRecord(@RequestParam(value="userCode") String var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyRecord/peccancyRecordByQueryType"})
    public Response<List<OrderPeccancyRecord>> queryPeccancyRecord(@RequestBody OrderPeccancyRecord var1, @RequestParam(value="type", required=false) String var2);

    @GetMapping(value={"/api/order/peccancy/orderPeccancyRecord/queryByPeccancyIdList"})
    public Response<List<OrderPeccancyRecord>> queryPeccancyRecordByIdList(@RequestParam(value="peccancyIdList") List<String> var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyRecord/queryBySelfConditions"})
    public Response<List<OrderPeccancyRecord>> queryPeccancyRecordBySelfConditions(@RequestBody QueryPeccancyConditionsDto var1);

    @PostMapping(value={"/api/order/peccancy/orderPeccancyRecord/queryPeccancyRecordTotal"})
    public Response<PeccancyRecordTotalDto> queryPeccancyRecordTotal(@RequestBody OrderPeccancyRecord var1);

    @PostMapping(value={"/api/order/withdrawals-record/createWithdrawalsOrder"})
    public Response<SaleOrder> createWithdrawalsOrder(@RequestBody CreateWithdrawalsOrderDto var1);

    @GetMapping(value={"/api/order/withdrawals-record/getByOrderCode"})
    public Response<WithdrawalsRecord> getWithdrawalsRecordByOrderCode(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/withdrawals-record/savePaymentInfo"})
    public Response saveWithdrawalsPaymentInfo(@Validated @RequestBody OrderCentPayDto var1);

    @GetMapping(value={"/api/order/withdrawals-record/summary"})
    public Response<WithdrawalsSummaryResultDto> getWithdrawalsSummary(@RequestParam(value="userCode") String var1, @RequestParam(value="pointType") String var2);

    @GetMapping(value={"/api/order/withdrawals-record/sumUsedVirtualCurrencyAmount"})
    public Response<BigDecimal> sumWithdrawalsUsedVirtualCurrencyAmount(@RequestParam(value="userCode") String var1, @RequestParam(value="pointType") String var2, @RequestParam(value="startTime", required=false) String var3, @RequestParam(value="endTime", required=false) String var4);

    @GetMapping(value={"/api/order/withdrawals-record/approvementCallBack"})
    public Response withdrawalsApprovementCallBack(@RequestParam(value="pass") Boolean var1, @RequestParam(value="code") String var2, @RequestParam(value="updateUser") String var3, @RequestParam(value="remark", required=false) String var4);

    @PostMapping(value={"/api/order/withdrawals-record/changeStatus"})
    public Response changeWithdrawalsOrderStatus(@RequestBody WithdrawalsOrderChangeStatusDto var1);

    @GetMapping(value={"/api/order/withdrawals-record/adminSearch"})
    public PageTable<SaleOrder> adminSearchWithdrawalsOrder(@SpringQueryMap WithdrawalsAdminSearchParamDto var1);

    @GetMapping(value={"/api/order/withdrawals-record/successRollbackUserCoupon"})
    public Response setWithdrawalsOrderSuccessRollbackUserCoupon(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/withdrawals-record/sendRollbackUserCouponMsg"})
    public Response sendWithdrawalsOrderRollbackUserCouponMsg(@RequestBody WithdrawalsOrderChangeStatusDto var1);

    @GetMapping(value={"/api/order/withdrawals-record-modify-log/listByOrderCode"})
    public Response<List<OrderWithdrawalsRecordModifyLog>> listWithdrawalsRecordModifyLog(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/withdrawals-record-modify-log/save"})
    public Response saveWithdrawalsRecordModifyLog(@RequestBody OrderWithdrawalsRecordModifyLog var1);

    @GetMapping(value={"/api/order/goods-order/adminSearch"})
    public PageTable<SaleOrder> adminSearchGoodsOrder(@SpringQueryMap GoodsAdminSearchParamDto var1);

    @PostMapping(value={"/api/order/goods-order/create"})
    public Response<SaleOrder> createGoodsOrder(@RequestBody CreateGoodsOrderDto var1);

    @GetMapping(value={"/api/order/goods-order/getByOrderCode"})
    public Response<GoodsOrder> getGoodsOrderByOrderCode(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/goods-order/savePaymentInfo"})
    public Response saveGoodsOrderPaymentInfo(@RequestBody OrderCentPayDto var1);

    @PostMapping(value={"/api/order/goods-order/changeStatus"})
    public Response changeGoodsOrderStatus(@RequestBody GoodsOrderChangeStatusDto var1);

    @PostMapping(value={"/api/order/goods-order/cashPay"})
    public Response<String> payGoodsOrderByCash(@RequestBody OrderCashPayDto var1);

    @GetMapping(value={"/api/order/goods-order/listGoodsOrderByOrderCodes"})
    public Response<List<GoodsOrder>> listGoodsOrderByOrderCodes(@RequestParam(value="orderCodeList") List<String> var1);

    @PostMapping(value={"/api/order/goods-order/receive"})
    public Response<GoodsOrder> receiveGoodsOrder(@RequestBody GoodsOrderReceiveDto var1);

    @PostMapping(value={"/api/order/goods-order/receiveGoodsOrderWithAddress"})
    public Response receiveGoodsOrderWithAddress(@RequestBody GoodsOrderDeliveryAddress var1);

    @GetMapping(value={"/api/order/goods-order/listGoodsOrderExpressDeliveryInfoByBestowCode"})
    public Response<List<GoodsOrderExpressDeliveryInfoDto>> listGoodsOrderExpressDeliveryInfoByBestowCode(@RequestParam(value="bestowCode") String var1);

    @GetMapping(value={"/api/order/goods-order/agentGiftBestowPageQuery"})
    public PageTable<SaleOrder> agentGiftBestowPageQuery(@RequestParam(name="createUserCode") String var1, @RequestParam(name="status", required=false) String var2, @RequestParam(name="limit", defaultValue="10") Integer var3, @RequestParam(name="page", defaultValue="1") Integer var4);

    @PostMapping(value={"/api/order/goods-order/agentGiftBestowOrderCount"})
    public Response<List<OrderCountResultDto>> agentGiftBestowOrderCount(@RequestBody OrderCountParamDto var1);

    @GetMapping(value={"/api/order/goods-order/findOrderTeamAndOrgAndAgent"})
    public Response<Map<String, List<OrderTeamAndOrgAndAgentDto>>> findOrderTeamAndOrgAndAgent();

    @PostMapping(value={"/api/order/goods-order/updateByOrderCode"})
    public Response updateGoodsOrderByOrderCode(@RequestBody GoodsOrder var1);

    @GetMapping(value={"/api/order/goods-order/pointExchangeCallScmFailedRetry"})
    public Response pointExchangeCallScmFailedRetry();

    @GetMapping(value={"/api/order/goods-order/grantGoodsOrderPageQuery"})
    public PageTable<SaleOrder> grantGoodsOrderPageQuery(@RequestParam(name="userCode", required=false) String var1, @RequestParam(name="status", required=false) String var2, @RequestParam(name="limit", defaultValue="10") Integer var3, @RequestParam(name="page", defaultValue="1") Integer var4);

    @GetMapping(value={"/api/order/goods-order/countPendingReceiveGrantGoodsOrder"})
    public Response<Integer> countPendingReceiveGrantGoodsOrder(@RequestParam(name="userMobile") String var1, @RequestParam(name="miniAppid") String var2);

    @PostMapping(value={"/api/order/goods-order/receiveGrantOrders"})
    public Response<List<GoodsOrder>> receiveGrantGoodsOrder(@RequestBody GoodsOrderReceiveDto var1);

    @PostMapping(value={"/api/order/goods-order/goodsOrderAutoReceipt"})
    public Response goodsOrderAutoReceipt(@Validated @RequestBody GoodsOrderAutoReceiptDto var1);

    @PostMapping(value={"/api/order/goods-order/updateShellOilStation"})
    public Response updateShellOilStation(@RequestBody UpdateGoodOrderShellOilStationDto var1);

    @GetMapping(value={"//api/order/goods-order/writeOffSheelOilOrder/{orderCode}"})
    public Response writeOffSheelOilOrder(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/goods-order-bestow-info/getByOrderCode"})
    public GoodsOrderBestowInfo getGoodsOrderBestowInfoByOrderCode(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/goods-order-delivery-address/saveOrUpdate"})
    public Response saveOrUpdateGoodsOrderDeliveryAddress(@RequestBody GoodsOrderDeliveryAddress var1);

    @DeleteMapping(value={"/api/order/goods-order-delivery-address/deleteByOrderCode"})
    public Response deleteGoodsOrderDeliveryAddressByOrderCode(@RequestParam(value="orderCode") String var1);

    @GetMapping(value={"/api/order/goods-order-delivery-address/getByOrderCde"})
    public Response<GoodsOrderDeliveryAddress> getGoodsOrderDeliveryAddressByOrderCode(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order"})
    public Response<Map<String, String>> createInsuranceGiftOrder(@RequestBody MerchantInsuranceGiftOrderDto var1);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/detail"})
    public Response<MerchantInsuranceGiftMainOrder> insuranceGiftMainOrderDetail(@RequestParam(value="storeCode") String var1, @RequestParam(value="mainCode") String var2, @RequestParam(value="itemCode", required=false) String var3);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/queryPage"})
    public PageTable<MerchantInsuranceGiftItemOrder> giftMainOrderPageTable(@RequestParam(value="orderType", defaultValue="STORE") String var1, @RequestParam(value="accountNumber", required=false) String var2, @RequestParam(value="keyword", required=false) String var3, @RequestParam(value="status", required=false) String var4, @RequestParam(value="storeCode", required=false) String var5, @RequestParam(value="limit", defaultValue="10") int var6, @RequestParam(value="page", defaultValue="1") int var7);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/queryPageHandlerStatus"})
    public PageTable<MerchantInsuranceGiftItemOrder> giftItemOrderPageTable(@RequestParam(value="orderType", defaultValue="STORE") String var1, @RequestParam(value="accountNumber", required=false) String var2, @RequestParam(value="keyword", required=false) String var3, @RequestParam(value="handleStatus", required=false) String var4, @RequestParam(value="storeCode", required=false) String var5, @RequestParam(value="limit", defaultValue="10") int var6, @RequestParam(value="page", defaultValue="1") int var7);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/confirm"})
    public Response<List<GiftCancelDto>> confirmGiftOrder(@RequestParam(value="storeCode", required=false) String var1, @RequestParam(value="mainCode") String var2, @RequestParam(value="itemCode") String var3, @RequestParam(value="giftCodes", required=false) String[] var4, @RequestParam(value="confirmOpenid", required=false) String var5);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/disagree"})
    public Response<Boolean> noConfirmGiftOrder(@RequestParam(value="storeCode", required=false) String var1, @RequestParam(value="mainCode") String var2, @RequestParam(value="itemCode") String var3);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/pay"})
    public Response<WxPayUnifiedOrderResultDto> giftOrderPay(@RequestBody MerchantInsuranceGifOrderPayDto var1);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/secondDetail"})
    public Response<MerchantInsuranceGiftItemOrder> giftSecondDetail(@RequestParam(value="itemCode") String var1);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/secondDetailByBestowCode"})
    public Response<MerchantInsuranceGiftItemOrder> giftSecondDetailBybestowCode(@RequestParam(value="bestowCode") String var1);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/payresult"})
    public Response<MerchantInsuranceGiftItemOrder> giftOrderPayResult(@RequestBody OrderCashPayDto var1);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/giving"})
    public Response getOrderGiving(@RequestParam(value="itemCode") String var1, @RequestParam(value="storeAccountName") String var2, @RequestParam(value="bestowCode") String var3, @RequestParam(value="onlyGoodSelfTheGift", required=false) Boolean var4);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/taskforconfirm"})
    public Response<List<String>> taskToInvalidForConfirmOrder();

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/giftrecall"})
    public Response<MerchantInsuranceGiftItemOrder> giftRecall(@RequestParam(value="storeCode", required=false) String var1, @RequestParam(value="itemCode") String var2, @RequestParam(value="storeAccountName") String var3);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/giftOrderReceive"})
    public Response giftOrderReceive(@RequestParam(value="bestowCode") String var1, @RequestParam(value="receiveUser", required=false) String var2);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/countforstatus"})
    public Response<Map<String, Integer>> giftOrderStatistics(@RequestParam(value="storeCode", required=false) String var1, @RequestParam(required=false, value="accountNumber") String var2, @RequestParam(required=false, value="orderType") String var3);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/countforhandlestatus"})
    public Response<Map<String, Integer>> giftOrderHandleStatusStatistics(@RequestParam(value="storeCode", required=false) String var1, @RequestParam(required=false, value="accountNumber") String var2, @RequestParam(required=false, value="orderType") String var3);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/giftSummary"})
    public Response<GiftSummaryDto> giftSummary(@RequestParam(value="orderType") String var1, @RequestParam(value="storeCode", required=false) String var2, @RequestParam(value="accountNumber", required=false) String var3);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/queryPage/more"})
    public PageTable<MerchantInsuranceGiftItemOrder> giftMainOrderWxPageTable(@RequestParam(value="orderType", defaultValue="MEMBER") String var1, @RequestParam(value="accountNumber", required=false) String var2, @RequestParam(value="keyword", required=false) String var3, @RequestParam(value="status", required=false, defaultValue="GIFT_COMPLETED") String var4, @RequestParam(value="storeCode", required=false) String var5, @RequestParam(value="month", required=false) String var6, @RequestParam(value="orderBy", required=false) String var7, @RequestParam(value="startBudget", required=false) Double var8, @RequestParam(value="endBudget", required=false) Double var9, @RequestParam(value="startCost", required=false) Double var10, @RequestParam(value="endCost", required=false) Double var11, @RequestParam(value="limit", defaultValue="10") int var12, @RequestParam(value="page", defaultValue="1") int var13);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/plan/queryPage/more"})
    public PageTable<MerchantInsuranceGiftItemOrder> giftPlanItemOrderWxPageTable(@RequestParam(value="orderType", defaultValue="MEMBER") String var1, @RequestParam(value="accountNumber", required=false) String var2, @RequestParam(value="planType", required=false) String var3, @RequestParam(value="keyword", required=false) String var4, @RequestParam(value="orderBy", required=false) String var5, @RequestParam(value="startMarket", required=false) Double var6, @RequestParam(value="endMarket", required=false) Double var7, @RequestParam(value="startCost", required=false) Double var8, @RequestParam(value="endCost", required=false) Double var9, @RequestParam(value="limit", defaultValue="10") int var10, @RequestParam(value="page", defaultValue="1") int var11);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/copy"})
    public Response copyPlanFromGift(@RequestBody CopyGiftDto var1);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/tovoid"})
    public Response giftToVoid(@RequestParam(value="itemCode") String var1);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/addCopyTime"})
    public Response giftCopyTimeAdd(@RequestParam(value="itemCode") String var1);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/current/count"})
    public Response<Map<String, Long>> giftBeingCount(@RequestParam(value="orderType") String var1, @RequestParam(value="storeCode", required=false) String var2, @RequestParam(value="memberNo", required=false) String var3);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/updategiftstatus"})
    public Response updateGiftStatus(@RequestBody GiftStatusUpdateDto var1);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/updateMainOrderInfo"})
    public Response updateGiftBaseInfoForMainByMainCode(@RequestBody MerchantInsuranceGiftMainOrder var1);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/updateItemOrderInfo"})
    public Response updateGiftBaseInfoForItemByItemCode(@RequestBody MerchantInsuranceGiftItemOrder var1);

    @GetMapping(value={"/api/merchant/insurancegift/shop/order/gift/deleteGiftByMainCode"})
    public Response deleteGiftByMainCode(@RequestParam(value="mainCode") String var1, @RequestParam(value="userCode") String var2, @RequestParam(value="orderType") String var3);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/saveGivingFailOrder"})
    public Response saveGivingFailOrder(@RequestBody MerchantInsuranceGiftFail var1);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/saveOpLog"})
    public Response savePlanOpLog(@RequestBody MerchantInsuranceGiftLog var1);

    @PostMapping(value={"/api/merchant/insurancegift/shop/order/gift/oplogList"})
    public Response<List<MerchantInsuranceGiftLog>> queryList(@RequestBody GiftLogQuery var1);

    @PostMapping(value={"/api/merchant/insurancegift/admin/gift/queryPage"})
    public PageTable<MerchantInsuranceGiftMainOrderAdminDto> adminGiftMainOrderPageTable(@RequestBody MerchantInsuranceGiftMainOrderAdminPageDto var1);

    @GetMapping(value={"/api/merchant/insurancegift/admin/gift/gainMainOrder/{mainCode}"})
    public Response<MerchantInsuranceGiftMainOrder> gainMainOrder(@PathVariable(value="mainCode") String var1);

    @GetMapping(value={"/api/merchant/insurancegift/admin/gift/gainMainOrderByWxCode/{wxCode}"})
    public Response<MerchantInsuranceGiftMainOrder> gainMainOrderByWxCode(@PathVariable(value="wxCode") String var1);

    @GetMapping(value={"/api/merchant/insurancegift/admin/gift/queryItemPage"})
    public PageTable<MerchantInsuranceGiftItemOrder> queryItemPage(@RequestParam(value="mainCode") String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/merchant/insurancegift/admin/gift/gainItemDetailList"})
    public PageTable<MerchantInsuranceGiftItemDetail> gainItemDetailList(@RequestParam(value="itemCode") String var1, @RequestParam(value="limit", defaultValue="20") int var2, @RequestParam(value="page", defaultValue="1") int var3);

    @GetMapping(value={"/api/merchant/insurancegift/admin/gift/gainItemDetailCount"})
    public Response<MerchantInsuranceGiftItemOrderDetailDTO> gainItemDetailCount(@RequestParam(value="itemCode") String var1);

    @GetMapping(value={"/api/merchant/insurancegift/admin/export"})
    public Response<List<MerchantInsuranceGiftMainOrderAdminDto>> adminExport(@RequestParam(value="code", required=false) String var1, @RequestParam(value="license", required=false) String var2, @RequestParam(value="mobile", required=false) String var3, @RequestParam(value="storeCode", required=false) String var4, @RequestParam(value="status", required=false) String var5, @RequestParam(value="orderType", required=false) String var6, @RequestParam(value="userName", required=false) String var7, @RequestParam(value="userMobile", required=false) String var8, @RequestParam(value="planType", required=false) String var9);

    @PostMapping(value={"/api/merchant/insurancegift/admin/newExport"})
    public Response<List<MerchantInsuranceGiftMainOrderAdminDto>> adminNewExport(@RequestBody MerchantInsuranceGiftMainOrderAdminPageDto var1);

    @GetMapping(value={"/api/merchant/insurancegift/admin/gift/gainItemOrderInfo/{itemCode}"})
    public Response<MerchantInsuranceGiftItemOrderDetailInfoAdminDto> gainItemOrderInfo(@PathVariable(value="itemCode") String var1);

    @GetMapping(value={"/api/merchant/insurancegift/admin/gift/lifecycleLog/{itemCode}"})
    public PageTable<MerchantInsuranceGiftLog> pageLifecycleLog(@PathVariable(value="itemCode") String var1, @RequestParam(value="limit", required=true) int var2, @RequestParam(value="page", required=true) int var3);

    @GetMapping(value={"/api/order/pay/wx/paymentflow/failure"})
    public Response taskToFailureForOrder();

    @GetMapping(value={"/api/merchant/insurancegift/admin/gift/gainOrderInsuranceGiftPayment/{mainCode}"})
    public Response<MerchantInsuranceGiftOrderPaymentDTO> gainOrderInsuranceGiftPayment(@PathVariable(value="mainCode") String var1);

    @GetMapping(value={"/api/order/withdrawals-fee-rate-config/pageQuery"})
    public PageTable<WithdrawalsFeeRateConfig> pageQueryWithdrawalsFeeRateConfig(@SpringQueryMap WithdrawalsFeeRatePageQueryDto var1);

    @PostMapping(value={"/api/order/withdrawals-fee-rate-config"})
    public Response saveOrUpdateWithdrawalsFeeRateConfig(@RequestBody WithdrawalsFeeRateConfig var1);

    @PostMapping(value={"/api/order/withdrawals-fee-rate-config/updateById"})
    public Response updateWithdrawalsFeeRateConfigById(@RequestBody WithdrawalsFeeRateConfig var1);

    @PostMapping(value={"/api/order/withdrawals-fee-rate-config/saveBatch"})
    public Response batchSaveWithdrawalsFeeRateConfig(@RequestBody List<WithdrawalsFeeRateConfig> var1);

    @PostMapping(value={"/api/order/withdrawals-fee-rate-config/updateBatch"})
    public Response batchUpdateWithdrawalsFeeRateConfig(@RequestBody List<WithdrawalsFeeRateConfig> var1);

    @DeleteMapping(value={"/api/order/withdrawals-fee-rate-config"})
    public Response deleteWithdrawalsFeeRateConfig(@RequestParam(value="id") Long var1);

    @GetMapping(value={"/api/order/withdrawals-fee-rate-config/getByMobile"})
    public Response<WithdrawalsFeeRateConfig> getWithdrawalsFeeRateConfigByMobile(@RequestParam(value="mobile", required=false) String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="queryDefault", required=false) Boolean var3);

    @GetMapping(value={"/api/order/withdrawals-fee-rate-config/getByIbc"})
    public Response<WithdrawalsFeeRateConfig> getWithdrawalsFeeRateConfigByIbc(@RequestParam(value="issuingBodyCode") String var1, @RequestParam(value="status", required=false) String var2, @RequestParam(value="queryDefault", required=false) Boolean var3);

    @GetMapping(value={"/api/order/withdrawals-fee-rate-config/listByMobileAndIssuingBody"})
    public Response<Map<String, WithdrawalsFeeRateConfig>> listWithdrawalsFeeRateByMobileAndIssuingBody(@RequestParam(value="mobile", required=false) String var1, @RequestParam(value="issuingBodyCodeList", required=false) List<String> var2);

    @PostMapping(value={"/api/order/withdrawals-fee-rate-config/checkIsExist"})
    public Response<List<String>> checkIsExist(@RequestBody List<String> var1);

    @GetMapping(value={"/api/order/withdrawals-fee-rate-config"})
    public Response<WithdrawalsFeeRateConfig> getWithdrawalsFeeRateConfig(@RequestParam(value="id") Integer var1);

    @PostMapping(value={"/api/order/withdrawals-fee-rate-config-log"})
    public Response saveWithdrawalsFeeRateConfigLog(@RequestBody WithdrawalsFeeRateConfigLog var1);

    @PostMapping(value={"/api/order/withdrawals-fee-rate-config-log/saveBatch"})
    public Response batchSaveWithdrawalsFeeRateConfigLog(@RequestBody List<WithdrawalsFeeRateConfigLog> var1);

    @GetMapping(value={"/api/order/withdrawals-fee-rate-config-log/pageQuery"})
    public PageTable<WithdrawalsFeeRateConfigLog> pageQueryWithdrawalsFeeRateConfigLogByCode(@RequestParam(value="code", required=false) String var1, @RequestParam(value="page") Integer var2, @RequestParam(value="limit") Integer var3);

    @PostMapping(value={"/api/order/goods-order-point-feedback/saveOrUpdate"})
    public Response saveOrUpdateGoodsOrderPointFeedback(@RequestBody GoodsOrderPointFeedback var1);

    @PostMapping(value={"/api/order/goods-order-point-feedback/batchSave"})
    public Response<List<GoodsOrderPointFeedback>> batchSaveGoodsOrderPointFeedback(@RequestBody List<GoodsOrderPointFeedback> var1);

    @GetMapping(value={"/api/order/goods-order-point-feedback/listByOrderCode"})
    public Response<List<GoodsOrderPointFeedback>> listGoodsOrderPointFeedbackByOrderCode(@RequestParam(value="orderCode") String var1);

    @GetMapping(value={"/api/order/goods-order-point-feedback/summary"})
    public Response<List<PointFeedbackSummaryDto>> goodsOrderPointFeedbackSummary(@RequestParam(value="memberUserCodeList") List<String> var1);

    @PostMapping(value={"/api/order/car/inspection/create"})
    public Response<SaleOrder> createCarInspectionOrder(@RequestBody CarInspectionOrderCreateDTO var1);

    @PostMapping(value={"/api/order/car/inspection/cashPayOrder"})
    public Response<SaleOrder> payCarInspectionOrderByCash(@RequestBody OrderCashPayDto var1);

    @GetMapping(value={"/api/order/car/inspection/retry"})
    public Response<List<CarInspectionOrder>> findPendingRetryCarInspectionOrder(@RequestParam(value="inspectionType") String var1, @RequestParam(value="status") String var2);

    @PostMapping(value={"/api/order/car/inspection/update"})
    public Response<SaleOrder> updateCarInspectionOrder(@RequestBody CarInspectionOrder var1);

    @PostMapping(value={"/api/order/car/inspection/callBack"})
    public Response<SaleOrder> carInspectionCallBackHandle(@RequestParam(value="orderNo") String var1, @RequestParam(value="status") Integer var2);

    @GetMapping(value={"/api/order/car/adminSearch"})
    public PageTable<SaleOrder> adminSearchCarInspectionOrder(@SpringQueryMap CarInspectionAdminSearchParamsDTO var1);

    @GetMapping(value={"/api/order/car/detail"})
    public Response<SaleOrder> carInspectionOrderDetail(@RequestParam(value="orderCode") String var1);

    @GetMapping(value={"/api/order/car/manualCreateDingJuOrder/{orderCode}"})
    public Response<String> manualCreateDingJuCarInspectionOrder(@PathVariable(value="orderCode") String var1);

    @GetMapping(value={"/api/order/car/count"})
    public Response<List<OrderCountResultDto>> countCarInspectionOrder(@RequestParam(value="userCode") String var1);

    @GetMapping(value={"/api/order/club/page"})
    public PageTable<OrderClubOrder> pageQueryClubOrder(@SpringQueryMap ClubOrderParamsDTO var1);

    @GetMapping(value={"/api/order/club/page-order-item"})
    public PageTable<OrderClubOrder> pageQueryClubOrderWithOrderItem(@SpringQueryMap ClubOrderParamsDTO var1);

    @GetMapping(value={"/api/order/club/query"})
    public Response<List<OrderClubOrder>> queryClubOrder(@RequestParam(value="statusList", required=false) List<String> var1, @RequestParam(value="roomCode", required=false) String var2, @RequestParam(value="issuingBodyCode", required=false) String var3);

    @PostMapping(value={"/api/order/club/create"})
    public Response createClubOrder(@RequestBody OrderClubOrder var1);

    @PostMapping(value={"/api/order/club/update-order-item"})
    public Response updateClubOrderWithOrderItem(@RequestBody OrderClubOrder var1);

    @PostMapping(value={"/api/order/club/update"})
    public Response updateClubOrder(@RequestBody OrderClubOrder var1);

    @GetMapping(value={"/api/order/club/count"})
    public Response<Integer> countOrderByStatus(@RequestParam(value="statusList", required=false) List<String> var1, @RequestParam(value="roomCode", required=false) String var2, @RequestParam(value="issuingBodyCode", required=false) String var3);

    @GetMapping(value={"/api/order/club/latest-order"})
    public Response<OrderClubOrder> getLatestClubOrder(@RequestParam(value="statusList", required=false) List<String> var1, @RequestParam(value="roomCode", required=false) String var2, @RequestParam(value="issuingBodyCode") String var3);

    @GetMapping(value={"/api/order/club/detail"})
    public Response<OrderClubOrder> getClubOrderDetail(@RequestParam(value="orderCode") String var1);

    @PostMapping(value={"/api/order/club/cancel"})
    public Response cancelClubOrder(@RequestBody OrderClubOrder var1);

    @PostMapping(value={"/api/order/club/settlement"})
    public Response settlementClubOrder(@RequestBody OrderClubOrder var1);

    @GetMapping(value={"/api/order/club/remark/list"})
    public Response<List<OrderClubOrderRemark>> clubOrderRemarkQueryList(@RequestParam(name="orderCode") String var1);

    @PostMapping(value={"/api/order/club/remark/addOrEdit"})
    public Response<OrderClubOrderRemark> clubOrderRemarkAddOrEdit(@RequestBody OrderClubOrderRemark var1, @RequestParam(name="operationUser", required=false) String var2);

    @PostMapping(value={"/api/order/club/pay"})
    public Response payClubOrderByCash(@RequestBody OrderCashPayDto var1);
}

