package com.rocogz.syy.order.entity.withdrawals;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 修复提现订单提现问券历史数据的中间表
 * </p>
 *
 * @author zhangmin
 * @since 2023-03-23
 */
@Setter @Getter
@Accessors(chain = true)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OrderWithdrawalRepairData extends IdEntity {

    /**
     * 提现订单编号
     */
    private String orderCode;

    /**
     * 小程序Id
     */
    private String miniAppid;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 主体行业类型： ENTERPRISE 合作企业； ROCO_ORG 保险公司； CAR_SALE_SERVICE 汽车4S店
     */
    private String industryType;

    /**
     * 待处理("PENDING"), 处理失败("FAILED"),处理成功("SUCCESS")
     */
    private String handleStatus;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 用户手机号
     */
    private String userMobile;

    /**
     * 用户openId
     */
    private String userOpenid;

    /**
     * 提现积分
     */
    private BigDecimal withdrawCent;

    /**
     * 提现到账金额
     */
    private BigDecimal withdrawAmt;

    /**
     * 提现订单的提现时间
     */
    private LocalDateTime withdrawTime;

    /**
     * 生成的问券编号
     */
    private String paperCode;

    /**
     * 题目数量
     */
    private Integer questNum;

    /**
     * 处理时间
     */
    private LocalDateTime handleTime;

    /**
     * 失败原因
     */
    private String reason;


    /**
     * 使用的第一笔提现积分的用户券编号
     */
    @TableField(exist = false)
    private transient String userCouponCode;

}
