package com.rocogz.syy.order.constant;

import lombok.Getter;
import lombok.Setter;

/**
 * 评价统计选项
 *
 * @author zhangmin
 * @date 2020/5/21
 */
@Getter @Setter
public class EvaluateStatisOption {

    //统计方式
    private EvaluateStatisWay statisWay;

    //统计时间范围,null表示不限制时间范围
    private StatisTimeRangeEnum timeRange;

    //该统计方式的对应的code值
    private String code;

    //自定义时间统计方式：传入到时间
    private String startTime;
    private String endTime;

    public EvaluateStatisOption() {
    }

    public EvaluateStatisOption(String code, EvaluateStatisWay statisWay) {
        this(code,statisWay,StatisTimeRangeEnum.ALL);
    }

    public EvaluateStatisOption(String code, EvaluateStatisWay statisWay,StatisTimeRangeEnum timeRange) {
        this.code = code;
        this.statisWay = statisWay;
        this.timeRange = timeRange;
    }


    /**
     * 订单评价的统计方式
     */
    @Getter
    public enum EvaluateStatisWay {
        STORE_CODE("按门店统计"),
        STORE_SERVICE_CODE("按门店服务项目统计"),
        AREA_CODE("按专区统计"),
        AREA_SERVICE_CODE("按专区服务项目统计");

        EvaluateStatisWay(String label) {
            this.label = label;
        }

        private String label;
    }
}
