package com.rocogz.syy.order.constant;

/**
 * 违章订单相关的 常量
 * @author zhangmin
 * @date 2020/7/29
 */
public class PeccancyConstant {


    /**
     * 鼎聚 车辆属性
     */
    public static class DictCarProperty {
        //字典类型编号
        public static final String TYPE_CODE = "DINGJU_CAR_PROPERTY";

        //=== 下面是字典值

        //个人车
        public static final String PERSONAL = "1";

        //公司车
        public static final String COMPANY = "2";
    }

    /**
     * 鼎聚 车辆类型
     */
    public static class DictDingJuCarType {
        //字典类型编号
        public static final String TYPE_CODE = "USER_SERVICE_CAR_TYPE";

        //=== 下面是字典值
    }


    /**
     * 违章鼎聚订单状态
     */
    public static class DictState {
        //鼎聚订单状态:(1:预约中；2:办理中；3:办理中；4:已完成；5:已取消；6:已完成；7:已完成)
        //字典类型编号
        public static final String TYPE_CODE = "PECCANCY_STATE";

        //=== 下面是字典值

        //预约中
        public static final String APPOINTING = "1";

        //办理中
        public static final String PROCESSING = "2";

        //办理中
        public static final String HANDLING = "3";

        //已完成 ok
        public static final String FINISH = "4";

        //车主端触发的 已取消
        public static final String MANUAL_CANCELED = "5";

        //回调取消
        public static final String CALLBACK_CANCELED = "9";

        //已完成
        public static final String COMPLETE = "6";

        //已完成
        public static final String DOWN = "7";
    }

    /**
     * 违章记录订单状态
     */
    public static class PeccancyRecordOrderStatus {
        /** 未下单 */
        public static final Integer NO_ORDER = 0;
        /** 已下单 */
        public static final Integer ORDER = 1;
        /** 未付款 */
        public static final Integer ORDER_NO_PAY = 2;
        /** 处理完成 */
        public static final Integer FINISH_ORDER = 3;
        /** 订单取消 */
        public static final Integer ORDER_CANCEL = 4;
        /** 其它渠道已处理 */
        public static final Integer OTHER_ORDER = 5;

        //正常状态变化流程: 未付款(2)-> 支付成功后变成 已下单(1)-> 处理完成(3)
    }

    /**
     * 违章记录处理标记
     */
    public static class PeccancyRecordProcessMark {
        /** 未处理 */
        public static final Integer UNTREATED = 0;
        /** 已处理 */
        public static final Integer PROCESSED = 1;
    }

    /**
     * 违章查询对应的类型
     */
    public static class PeccancyType {
        /** 待处理 */
        public static final String PENDING = "PENDING";
        /** 已处理 */
        public static final String PROCESSED = "PROCESSED";
        /** 全部 */
        public static final String ALL = "ALL";
    }


}
