package com.rocogz.syy.order.dto.goods;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.AdminBaseSearchDto;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 管理后台-> 商品订单 搜索 条件
 * @author ranxiangfu
 * @date 2020/8/18
 */
@Data
public class GoodsAdminSearchParamDto extends AdminBaseSearchDto {

    public GoodsAdminSearchParamDto() {
        setOrderType(OrderConstant.DictOrderType.GOODS_ORDER);
    }

    private String addressee;
    private String addresseeMobile;
    private String goodsCode;
    private String goodsName;
    private String goodsSupplierCode;
    private String expressDeliveryName;
    private String expressDeliveryNumber;
    private String payWay;
    private String finishStartTime;
    private String finishEndTime;

    /**
     * 是否是查询：未填写快递信息, 未填写快递则必须满足如下条件
     * 1）订单的商品是【实物商品】product_type='GOODS'
     * 2）订单状态是【待收货】
     * 3）订单未填写快递信息：快递名称、快递单号
     */
    private Boolean notFillExpress;

    /**
     * 是否虚拟商品
     */
    private Boolean virtualGoods;

    private Boolean changeStatus2Delivered;

    private List<String> supplierCodeList;
    private String bUserName;
    private String bUserMobile;
    private String bTeamCode;
    private String bOrgCode;
    private String bAgentCode;
    private String channel;
    private String planCode;
    private String planType;
    private String planModel;
    private String platformCode;
    private String sendStartTime;
    private String sendEndTime;

    /**
     * 积分兑换产品编码
     */
    private String pointExchangeProductCode;

    /**
     * 积分兑换产品名称
     */
    private String pointExchangeProductName;

    /**
     * 平台产品类型
     */
    private String productType;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * erp产品编码
     */
    private String erpProductCode;
}
