package com.rocogz.syy.order.dto.goods;

import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 壳牌加油业务：车主端去使用页面 ：更新商品兑换订单的壳牌油站信息
 * @author zhangmin
 */
@Setter @Getter
public class UpdateGoodOrderShellOilStationDto {

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 壳牌油站编号 【壳牌加油】
     * 壳牌兑换的订单状态流转：兑换创建商品订单->PENDING_DELIVERY(待发货)-> 供应链下单并发放用户券成功后-> FINISHED(已完成) -> 车主端使用 -> 触发供应链上游,上游下单成功后-> 更新为主订单usedTime,则是已使用
     *
     * @see QiaoPaiOilStationInfo#stationCode
     */
    private String oilStation;

    /**
     * 壳牌油站名 【壳牌加油】
     */
    private String oilStationName;

    /**
     * 壳牌油枪编号 【壳牌加油】
     */
    private String oilGun;

    /**
     * 壳牌油枪名 【壳牌加油】
     */
    private String oilGunName;

    /**
     * 壳牌油品、油号的编号：例如：95【壳牌加油】
     */
    private String oilNo;

    /**
     * 壳牌油品/油号名称：例如：95#【壳牌加油】
     */
    private String oilNoName;

    /**
     * 壳牌油品单价【壳牌加油】
     */
    private BigDecimal oilUnitPrice;


}
