package com.rocogz.syy.order.dto.insurancegift;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class MerchantInsuranceGiftItemOrderDetailDTO implements Serializable {

    /**
     * 二级订单号
     */
    private String itemCode;

    /**
     * 方案报价时间
     */
    private LocalDateTime offerTime;

    /**
     * 意向单状态
     */
    private String status;

    /**
     * 状态的流转状态
     * 方案状态
     */
    private String currentStatus;

    /**
     * 礼赠说明
     */
    private String remark;

    /**
     * 方案市场价
     */
    private BigDecimal totalMarketPrice;

    /**
     * 方案市场价Str
     */
    private String totalMarketPriceStr;

    /**
     * 方案成本价
     */
    private BigDecimal totalCostPrice;

    /**
     * 方案成本价Str
     */
    private String totalCostPriceStr;

    /**
     * 方案结算价
     */
    private BigDecimal amount;

    /**
     * 方案结算价Str
     */
    private String amountStr;

    /**
     * 礼品市场价
     */
    private BigDecimal marketPrice;

    /**
     * 礼品市场价Str
     */
    private String marketPriceStr;

    /**
     * 礼品成本价
     */
    private BigDecimal costPrice;

    /**
     * 礼品成本价Str
     */
    private String costPriceStr;

    /**
     * 礼品结算价
     */
    private BigDecimal settlePrice;

    /**
     * 礼品结算价Str
     */
    private String settlePriceStr;

    /**
     * 现金
     */
    private BigDecimal cash;

    /**
     * 礼品数
     */
    private Integer giftCount;

    /**
     * 礼品列表
     */
    private List<MerchantInsuranceGiftItemDetailDTO> giftItemDetailDTOs;

}
