package com.rocogz.syy.order.dto.insurancegift;

import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftItemDetail;
import com.rocogz.syy.order.entity.insuranceGift.MerchantInsuranceGiftItemGoodReady;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 商户投保礼创建订单入参对象
 *
 * @author：liangyongtong
 * @since：2020/8/31
 */
@Data
public class MerchantInsuranceGiftItemOrderDetailInfoAdminDto implements Serializable {

    private static final long serialVersionUID = -1359427746550782744L;

    private String userName;
    private String userMobile;
    private String userCode;
    private String openid;
    private String teamName;
    private String orgName;
    private String agentName;
    private String orderType;
    private LocalDateTime createTime;
    private LocalDateTime updateTime;
    private String mobile;
    private String customerName;
    private String license;
    private String itemCode;
    private String currentStatus;
    private String handleStatus;
    private String planType;
    private LocalDateTime offerTime;
    private String planModel;
    private String hasCash;
    private BigDecimal totalBudget;
    private BigDecimal cash;
    private String addressMobile;
    private String addressee;
    private String fullAddress;
    private String expressDeliveryName;
    private String expressDeliveryNumber;
    private LocalDateTime receiveTime;
    private Integer selected;
    private Integer needSelected;
    private String marketPriceStr;
    private String costPriceStr;
    private String budgetCostDifferenceStr;
    private String goodsCode;
    private List<String> relateCodeList;
    private Map<String, MerchantInsuranceGiftItemGoodReady> map;
    private Map<String, MerchantInsuranceGiftItemDetail> detailMap;
    private List<MerchantInsuranceGiftItemGoodReady> readyList;
    private List<MerchantInsuranceGiftItemOrderDetailInfoAdminDto> bestowInfoList;

}
