package com.rocogz.syy.order.dto.oil;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 *  支付成功后,返回的对象
 * @author zhangmin
 * @date 2020/5/30
 */
@Setter @Getter @Accessors(chain = true)
public class OilOrderPayedResultDto extends OilOrderBaseDto {

    /**
     * 成功支付的 车服订单号
     */
    private String orderCode;

    /**
     * 会员编号
     */
    private String userCode;


    /**
     * 第三方支付平台的支付单号或支付交易号 [必须]
     */
    private String payCode;


    /**
     * 鼎聚权益编号
     */
    private String powerNo;

    /**
     * 支付的现金 金额 [必须]
     */
    private BigDecimal payAmt;

    /**
     * 现金支付方式：是微信支付,还是支付宝支付  [必须]
     * @see OrderConstant.DictPayWay#WEIXIN
     */
    private String payWay;

    /**
     * 本次支付 所使用的 核销码列表
     */
    private List<String> writeOffCodeList;

}
