package com.rocogz.syy.order.dto.oil;

import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 用户券 支付加油电子券Item Dto
 * @author zhangmin
 * @date 2020/5/31
 */
@Setter @Getter
public class UserCouponPayItemDto {

    /**
     * 鼎聚权益编号
     */
    private String powerNo;

    /**
     * 用户券编号[必传]
     * 如果是积分兑换商品订单，则是com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCoupon#code
     */
    private String userCouponCode;

    /**
     * 核销码 例如：F42A1AB62BC81727 [必传]
     */
    private String writeOffCode;

    /**
     * 该券 所支付的金额 [必传]
     */
    private BigDecimal payAmt;

    /**
     * sourceUserCouponCode
     * @see com.rocogz.syy.equity.entity.oilCardUserCoupon.EquityOilCardUserCoupon#sourceUserCouponCode
     */
    private String sourceUserCouponCode;
}
