package com.rocogz.syy.order.dto.withdrawals;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.AdminBaseSearchDto;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * 管理后台-> 提现订单 搜索 条件
 * @author ranxiangfu
 * @date 2020/8/4
 */
@Data
public class WithdrawalsAdminSearchParamDto extends AdminBaseSearchDto  {

    public WithdrawalsAdminSearchParamDto() {
        setOrderType(OrderConstant.DictOrderType.WITHDRAWALS_ORDER);
    }

    /**
     * 收款账户/卡号
     */
    private String account;

    /**
     * 提现状态: PENDIND-待审批; PENDIND_PROCESS-(已受理/待处理); REFUSE-(未受理/审核不通过);
     *      PROCESSING-(转账中/处理中); SUCCESS-提现成功; FAIL-提现失败;
     */
    private String withdrawalsStatus;

    /**
     * 提现方式; ALIPAY:支付宝, BANK:银行账户
     */
    private String withdrawalsWay;

    /**
     * 身份证号码【模糊匹配】
     */
    private String idCard;

    /**
     * 收款人姓名 【模糊匹配】
     * 提现方式：如果是 ALIPAY（支付宝),则用id_name匹配
     * 提现方式：如果是 BANK（银行账户),则用bank_cardholder_name匹配
     */
    private String payeeName;

    /**
     * 收款人手机号码 【模糊匹配】
     */
    private String payeeMobile;

    /**
     * 更新时间起始
     */
    private String updateStartTime;

    /**
     * 更新时间结束
     */
    private String updateEndTime;

    //如果 maxCent!=null,则查询 积分 <= maxCent的提现订单
    private BigDecimal maxCent;



    public String getIdCardLike() {
        if(StringUtils.isBlank(idCard)) {
            return null;
        }
        return StringUtils.wrap(idCard,"%");
    }


    public String getPayeeMobileLike() {
        if(StringUtils.isBlank(payeeMobile)) {
            return null;
        }
        return StringUtils.wrap(payeeMobile,"%");
    }


    public String getPayeeNameLike() {
        if(StringUtils.isBlank(payeeName)) {
            return null;
        }
        return StringUtils.wrap(payeeName,"%");
    }

}
