package com.rocogz.syy.order.entity.goods;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-商品订单
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_goods_order")
public class GoodsOrder extends IdEntity {

    private static final long serialVersionUID = -6947173409061140577L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 是否虚拟商品
     *  只有商品类型是实物时,才区分虚拟和非虚拟
     */
    private Boolean virtualGoods;

    /**
     * 是否是赠送订单
     */
    private Boolean bestow;

    /**
     * 商品编号(平台产品编号)
     */
    private String goodsCode;

    /**
     * 平台产品的品牌：壳牌的用来逻辑判定
     */
    private String brandCode;

    /**
     * 商品供应商编号
     */
    private String goodsSupplierCode;

    /**
     * 商品供应商名称
     */
    private String goodsSupplierName;

    /**
     * 商品名称(平台产品名称)
     */
    private String goodsName;

    /**
     * 商品展示图片url
     */
    private String goodsPictureUrl;

    /**
     * 商品单价(积分兑换产品-积分兑换价(单价))
     */
    private BigDecimal goodsUnitPrice;

    /**
     * 商品购买数量
     */
    private Integer goodsAmount;

    /**
     * 商品总价(积分兑换产品-积分总价)
     */
    private BigDecimal goodsTotalPrice;

    /**
     * 订单总金额(含运费)
     */
    private BigDecimal totalAmount;

    /**
     * 积分已支付总金额
     */
    private BigDecimal pointPayedTotalAmount;

    /**
     * 现金已支付总金额
     */
    private BigDecimal cashPayedTotalAmount;

    /**
     * 快递运输费用
     */
    private BigDecimal transportFeeAmount;

    /**
     * 快递公司名称：例如 顺丰快递
     */
    private String expressDeliveryName;

    /**
     * 快递单号，例如：SF10001
     */
    private String expressDeliveryNumber;

    /**
     * 发货时间
     */
    private LocalDateTime sendTime;

    /**
     * 确认收货时间
     */
    private LocalDateTime receiveTime;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 支付方式(POINT:积分; CASH:现金;POINT_AND_CASH:积分+现金)
     *
     * @see com.rocogz.syy.order.constant.OrderConstant.DictGoodsOrderPayWay
     */
    private String payWay;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 下单类型
     *
     * @see OrderConstant.DictGoodsOrderCreateType#EXCHANGE_GOODS_BUY
     */
    private String createType;

    /**
     * 油卡充值手机号码
     */
    private String oilRechargeMobile;

    /**
     * 积分兑换产品编码
     *
     * @see com.rocogz.merchant.entity.exchangeGoodsPoints.MerchantExchangeGoodsPoints#code
     */
    private String pointExchangeProductCode;

    /**
     * 积分兑换产品名称
     *
     * @see com.rocogz.merchant.entity.exchangeGoodsPoints.MerchantExchangeGoodsPoints#name
     */
    private String pointExchangeProductName;

    /**
     * 平台产品类型
     * 产品类型是 GOODS(实物)时，又区分 虚拟 和 非虚拟
     * @see com.rocogz.merchant.entity.goods.MerchantGoods#goodsType
     */
    private String productType;

    /**
     * 代理商产品编码
     */
    private String agentProductCode;

    /**
     * 代理商产品名称
     */
    private String agentProductName;

    /**
     * 兑换积分产品的代理商产品-市场价
     * 1.如果是油卡直充 = (油卡直冲时是到账金额，即油卡充值是选择或输入的充值面额)
     * 2.如果是非固定面额的电卡产品 = 输入的充值面额
     * 3.其他产品类型时： agentProductMarketPrice = MerchantExchangeGoodsPoints#marketPrice
     */
    private BigDecimal agentProductMarketPrice;

    /**
     * 代理商产品- 额度扣减单价
     * @see MerchantAgentGoods#purchasePrice
     */
    private BigDecimal agentProductPurchasePrice;

    /**
     *  代理商产品-采购结算价，也就是 备付金扣减单价
     * @see MerchantAgentGoods#purchaseSettlePrice
     */
    private BigDecimal agentProductPurchaseSettlePrice;


    // ===  壳牌加油 积分兑换商品订单 相关字段如下 ==

    /**
     * 壳牌油站编号 【壳牌加油】
     * 壳牌兑换的订单状态流转：兑换创建商品订单->PENDING_DELIVERY(待发货)-> 供应链下单并发放用户券成功后-> FINISHED(已完成) -> 车主端使用 -> 触发供应链上游,上游下单成功后-> 更新为主订单usedTime,则是已使用
     *
     * @see QiaoPaiOilStationInfo#stationCode
     */
    private String oilStation;

    /**
     * 壳牌油站名 【壳牌加油】
     */
    private String oilStationName;

    /**
     * 壳牌油枪编号 【壳牌加油】
     */
    private String oilGun;

    /**
     * 壳牌油枪名 【壳牌加油】
     */
    private String oilGunName;

    /**
     * 壳牌油品、油号的编号：例如：95【壳牌加油】
     */
    private String oilNo;

    /**
     * 壳牌油品/油号名称：例如：95#【壳牌加油】
     */
    private String oilNoName;

    /**
     * 加油升数,例如：5.6L【壳牌加油】
     */
    private BigDecimal oilVolume;

    // ===  壳牌加油 积分兑换商品订单 end ==


    /**
     * 订单收货地址信息
     */
    @TableField(exist = false)
    private GoodsOrderDeliveryAddress goodsOrderDeliveryAddress;

    /**
     * 商品订单赠送信息
     */
    @TableField(exist = false)
    private GoodsOrderBestowInfo goodsOrderBestowInfo;

    /**
     * 商品订单B端代理人信息
     */
    @TableField(exist = false)
    private GoodsOrderAgentUserInfo goodsOrderAgentUserInfo;

    /**
     * 剩余需要现金支付的金额
     */
    @TableField(exist = false)
    private BigDecimal cashNeedPayAmount;

    /**
     * 是否是来自活动弹窗创建的订单.
     */
    private Boolean createFromAlter;

    /**
     * 调用分销下单是否成功
     */
    private Boolean callScmSuccess;

    /**
     * 调用分销下单次数
     */
    private Integer callScmCnt;

    /**
     * 理论上第一次调用分销下单的时间（晚于这个时间的油卡直冲订单不允许取消）
     */
    private LocalDateTime firstTimeCallScm;

    /**
     * 最后一次调用分销下单时间
     */
    private LocalDateTime lastTimeCallScm;

    /**
     * 调用分销下单返回的数据
     */
    private String callScmRes;

    /**
     * 分销明细订单编号
     */
    private String scmOrderItemCode;

    /**
     * erp产品编码
     */
    private String erpProductCode;


    /**
     * 是否是 电卡产品 兑换订单
     */
    public boolean isElectricOrder() {
        boolean electricOrder = "FIXED_ELECTRIC".equalsIgnoreCase(productType) ||
                "FLEXIBLE_ELECTRIC".equalsIgnoreCase(productType);

        return electricOrder;
    }
}
