package com.rocogz.syy.order.entity.orders.club;

import com.baomidou.mybatisplus.annotation.TableField;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.constant.ClubOrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 会所订单表
 * zjk 2022-9-23 16:40:37
 */
@Setter
@Getter
@Accessors(chain = true)
public class OrderClubOrder extends IdEntity {

    /**
     *订单编码
     */
    private String code;
    /**
     * 用餐人数
     */
    private Integer dinersNum;
    /**
     * 包房编号
     */
    private String roomCode;

    /**
     * 包房名称
     */
    @TableField(exist = false)
    private String roomName;

    /**
     * 包房图片
     */
    @TableField(exist = false)
    private String roomImg;
    /**
     * 发放主体编码
     */
    private String issuingBodyCode;
    /**
     * 总价格
     */
    private BigDecimal totalPrice;
    /**
     * 需支付价格
     */
    private BigDecimal payPrice;
    /**
     * 订单状态
     * @see ClubOrderConstant.DictClubOrderStatus
     */
    private String status;
    /**
     * 状态流转时间
     */
    private LocalDateTime statusTime;
    /**
     * 支付方式
     * @see ClubOrderConstant.DictClubPayType
     */
    private String payType;
    /**
     * 意见
     */
    private String opinion;
    /**
     * 支付人openId
     */
    private String payOpenid;
    /**
     * 支付人手机号
     */
    private String payPhone;
    /**
     * 会所订单类型
     * @see ClubOrderConstant.DictClubOrderType
     */
    private String orderType;
    /**
     * 创建人
     */
    private String createUser;
    /**
     * 创建时间
     */
    private LocalDateTime createTime;
    /**
     * 更新人
     */
    private String updateUser;
    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 订单明细列表
     */
    @TableField(exist = false)
    private List<OrderClubOrderItem> orderItemList;

    /**
     * 订单备注列表
     */
    @TableField(exist = false)
    private List<OrderClubOrderRemark> remarkList;

}
