package com.rocogz.syy.order.entity.orders.club;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import com.rocogz.syy.order.constant.ClubOrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 会所订单日志表
 * @author 陈煜敏
 * @date 2022-9-27 16:40:37
 */
@Setter
@Getter
@Accessors(chain = true)
@TableName("order_club_order_log")
public class OrderClubOrderLog extends IdEntity {

    /**
     *订单编码
     */
    private String orderCode;

    /**
     * 操作
     */
    private String action;

    /**
     * 操作前状态
     * @see ClubOrderConstant.DictClubOrderStatus
     */
    private String beforeStatus;

    /**
     * 操作后状态
     * @see ClubOrderConstant.DictClubOrderStatus
     */
    private String afterStatus;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
