package com.rocogz.syy.order.entity.peccancy;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 违章记录
 * </p>
 *
 * @author liangyongtong
 * @since 2020-07-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderPeccancyRecord extends IdEntity {

    /**
     * 用户编码
     */
    private String userCode;

    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 车辆类型
     */
    private String carType;

    /**
     * 发动机号(后六位)
     */
    private String engineNumber;

    /**
     * 车架号(后六位)
     */
    private String frameNumber;

    /**
     * 车辆性质； 1个人车，2公司车
     */
    private Integer carProperty;

    /**
     * 违章id（下单时候用到）
     */
    private String peccancyId;

    /**
     * 监控编号
     */
    private String peccancyNumber;

    /**
     * 违章时间
     */
    private String peccancyAt;

    /**
     * 违章地点
     */
    private String peccancySite;

    /**
     * 违章行为
     */
    private String peccancyAct;

    /**
     * 违法行为
     */
    private String illegalAct;

    /**
     * 违法城市
     */
    private String illegalCity;

    /**
     * 处理标记 0未处理 1已处理
     */
    private String processMark;

    /**
     * 缴款标记 0未缴款 1已缴款
     */
    private String paymentMark;

    /**
     * 扣分
     */
    private Integer deductedPoints;

    /**
     * 罚款金额
     */
    private BigDecimal fines;

    /**
     * 违章类型：1电子眼 2现场
     */
    private Integer type;

    /**
     * 决定书编号
     */
    private String decisionNumber;

    /**
     * 本年度已用于办理违章的驾照数量，大于等于3超证，-1则不支持查询
     */
    private Integer numOfLicense;

    /**
     * 服务费用，不包含本金，-1代表不可办理
     */
    private BigDecimal poundage;

    /**
     * 本人本证报价，-1不可办理
     */
    private BigDecimal usPriceFirst;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;
}
