package com.rocogz.syy.order.entity.withdrawals;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-提现订单修改记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2021-07-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_withdrawals_record_modify_log")
public class OrderWithdrawalsRecordModifyLog extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 身份证号码
     */
    private String idCard;

    /**
     * 收款人姓名
     */
    private String payeeName;

    /**
     * 收款人手机号码
     */
    private String payeeMobile;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 收款账户
     */
    private String payeeAccount;

    /**
     * 修改凭证
     */
    private String voucherImg;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 提现方式
     */
    @TableField(exist = false)
    private String withdrawalsWay;

}
