package com.rocogz.syy.order.entity.withdrawals;

import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <p>
 * 订单中心-提现订单记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_withdrawals_record")
public class WithdrawalsRecord extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 消耗的虚拟货币总金额
     */
    private BigDecimal usedVirtualCurrencyAmount;

    /**
     * 手续费 = usedVirtualCurrencyAmount * feeRate
     */
    private BigDecimal feeAmount;

    /**
     * 费率
     */
    private BigDecimal feeRate;

    /**
     * 返点金额 =  rebateRate * usedVirtualCurrencyAmount
     */
    private BigDecimal rebateAmount;

    /**
     * 返点率
     */
    private BigDecimal rebateRate;

    /**
     * 是否已返点
     */
    private Boolean rebated;

    /**
     * 返点处理时间
     */
    private Boolean rebateProcessTime;

    /**
     * 返点处理业务单号
     */
    private String rebateProcessBusinessCode;

    /**
     * 到账金额 =  usedVirtualCurrencyAmount - feeAmount
     */
    private BigDecimal amountToTheAccount;

    /**
     * 身份证姓名
     * 提现方式是：ALIPAY时的 收款人姓名
     */
    private String idName;

    /**
     * 身份证号码
     */
    private String idCard;

    /**
     * 提现方式; ALIPAY:支付宝, BANK:银行账户
     */
    private String withdrawalsWay;

    /**
     * 支付宝账户
     */
    private String alipayAccount;

    /**
     * 银行账户持卡人姓名,
     * withdrawalsWay提现方式是：BANK 时的 收款人姓名
     */
    private String bankCardholderName;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行账户
     */
    private String bankAccount;

    /**
     * 提现状态: PENDIND-待审批; PENDIND_PROCESS-(已受理/待处理); REFUSE-(未受理/审核不通过);
     *          PROCESSING-(转账中/处理中); SUCCESS-提现成功; FAIL-提现失败;
     * @see OrderConstant.DictWithdrawalsStatus
     */
    private String withdrawalsStatus;

    /**
     * 备注，可用于填写审核不通过、提现失败的原因
     */
    private String remark;

    /**
     * 当订单审核不通过或者提现失败时，用于记录是否成功回退了用户券
     */
    private String isRollbackCouponSuccess;

    /**
     * 积分账户类型
     */
    private String pointType;

    /**
     * 收款人手机号码.
     */
    private String payeeMobile;


    /**
     * 问券答题试券编号
     */
    private String paperCode;

    /**
     * 问券试券题目数量
     */
    private Integer questNum;

}
