package com.rocogz.syy.order.constant;

/**
 * 优惠券的 常量信息 该数据来源于 常量表 basic_dict_data
 * @author zhangmin
 * @date 2020/4/29
 */
public final class CouponConstant {

    /**
     * 优惠券状态 =》 上架状态
     */
    public static final String  COUPON_STATUS_LIST = "TO_LIST";


    //下面是用户券状态

    /**
     * 用户券状态 =》 未生效
     */
    public static final String  USER_COUPON_STATUS_UN_EFFECTIVE = "UN_EFFECTIVE";

    /**
     * 用户券状态 =》 未使用，只有此状态的用户券 才能核销
     */
    public static final String  USER_COUPON_STATUS_NORMAL = "NORMAL";

    /**
     * 用户券状态 =》已使用
     */
    public static final String  USER_COUPON_STATUS_USED = "USED";

    /**
     * 用户券状态 =》 已过期
     */
    public static final String  USER_COUPON_STATUS_INVALID = "INVALID";

    /**
     * 用户券状态 =》 已冻结
     */
    public static final String  USER_COUPON_STATUS_FROZEN = "FROZEN";

    /**
     * 用户券状态 =》已作废
     */
    public static final String  USER_COUPON_STATUS_CANCEL = "CANCEL";

    /**
     * 用户券状态 =》转赠中
     */
    public static final String  USER_COUPON_STATUS_TRANSFER = "TRANSFER";


    // 下面是 券的使用范围

    /**
     * 券的专区使用范围：指定专区可用
     */
    public static final String  USE_RANGE_PINT_AREA = "POINT_AREA";

    /**
     * 券的门店使用范围：指定门店可用
     */
    public static final String  USE_RANGE_POINT_STORE = "POINT_STORE";

    /**
     * 券的使用范围：全部门店/全部专区 可用
     */
    public static final String  USE_RANGE_ALL = "ALL";

}
