package com.rocogz.syy.order.dto.peccancy;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 违章统计
 * @author：liangyongtong
 * @since：2020/8/3
 */
@Getter
@Setter
public class PeccancyRecordTotalDto implements Serializable {

    private static final long serialVersionUID = -8310052434802934678L;

    /** 违章数 */
    private Integer peccancyCount = 0;
    /** 罚款金额 */
    private BigDecimal fines = BigDecimal.ZERO;
    /** 扣分 */
    private Integer deductedPoints = 0;
    /** 待处理违章数 */
    private Integer pendingCount = 0;

    /**
     * 加违章数
     * @param count 新违章数
     * @return
     */
    public PeccancyRecordTotalDto addPeccancyCount(int count) {
        this.peccancyCount += count;
        return this;
    }

    /**
     * 加罚款金额
     * @param fines 新罚款金额
     * @return
     */
    public PeccancyRecordTotalDto addFines(BigDecimal fines) {
        this.fines = this.fines.add(fines);
        return this;
    }

    /**
     * 扣分数
     * @param deductedPoints 新扣分数
     * @return
     */
    public PeccancyRecordTotalDto addDeductedPoints(int deductedPoints) {
        this.deductedPoints += deductedPoints;
        return this;
    }

    /**
     * 待处理违章数
     * @param pendingCount 新待处理违章数
     * @return
     */
    public PeccancyRecordTotalDto addPendingCount(int pendingCount) {
        this.pendingCount += pendingCount;
        return this;
    }
}
