package com.rocogz.syy.order.dto.peccancy;

import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrder;
import com.rocogz.syy.order.entity.peccancy.OrderPeccancyOrderItem;
import lombok.Getter;
import lombok.NonNull;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 查询违章信息条件
 * @author：liangyongtong
 * @since：2020/8/4
 */
@Getter
@Setter
public class QueryPeccancyConditionsDto implements Serializable {
    private static final long serialVersionUID = 6026584350411146502L;

    /**
     * 用户编号
     */
    @NonNull
    private String userCode;

    /**
     * 车牌号
     */
    @NonNull
    private String plateNumber;

    /**
     * 车辆性质； 1:个人车 2:单位车
     */
    @NonNull
    private Integer carProperty;

    /**
     * 车架号后6位
     */
    @NonNull
    private String frameNumber;

    /**
     * 发动机后6位
     */
    @NonNull
    private String engineNumber;

    /**
     * 车辆类型
     */
    @NonNull
    private String carType;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 违章id
     */
    private List<String> peccancyIds;


    public static QueryPeccancyConditionsDto valueOfPeccancyOrder(OrderPeccancyOrder peccancyOrder) {
        QueryPeccancyConditionsDto conditionsDto = new QueryPeccancyConditionsDto();

        conditionsDto.setCarProperty(Integer.valueOf(peccancyOrder.getCarProperty()));
        conditionsDto.setUserCode(peccancyOrder.getUserCode());
        conditionsDto.setCarType(peccancyOrder.getCarType());
        conditionsDto.setEngineNumber(peccancyOrder.getEngineNumber());
        conditionsDto.setFrameNumber(peccancyOrder.getFrameNumber());
        conditionsDto.setPlateNumber(peccancyOrder.getPlateNumber());
        conditionsDto.setOrderCode(peccancyOrder.getOrderCode());

        List<String> peccancyIdList = peccancyOrder.getItemList().stream().map(OrderPeccancyOrderItem::getPeccancyId).collect(Collectors.toList());
        conditionsDto.setPeccancyIds(peccancyIdList);
        return conditionsDto;
    }

}
