package com.rocogz.syy.order.dto.withdrawals;

import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.dto.peccancy.CreatePeccancyOrderDto;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 创建提现订单 Dto
 * @author ranxiangfu
 * @date 2020/8/4
 */
@Setter @Getter @Accessors(chain = true)
public class CreateWithdrawalsOrderDto {

    /**
     * 提现订单编号
     */
    private String orderCode;

    /**
     * 会员编号 [必传]
     */
    @NotEmpty
    private String userCode;

    /**
     * 会员手机号 [必传]
     */
    @NotEmpty
    private String mobile;

    /**
     * 会员openid [必传]
     */
    @NotEmpty
    private String openId;

    /**
     * 下单来源平台编号，如：syy  [必传]
     * @see OrderConstant#DICT_PLATFORM_CODE_CAR_SERVICE
     */
    @NotEmpty
    private String platformCode;

    /**
     * 下单渠道：车主端，商户端，管理后台,接口调用 [必传]
     *
     * @see OrderConstant.DictChannel
     */
    @NotEmpty
    private String channel;

    /**
     * 所属平台appId
     */
    private String miniAppid;

    /**
     * 消耗的虚拟货币总金额
     */
    @NotNull
    private BigDecimal usedVirtualCurrencyAmount;

    /**
     * 积分账户类型
     */
    @NotNull
    private String pointType;

    /**
     * 手续费
     */
    @NotNull
    private BigDecimal feeAmount;

    /**
     * 费率
     */
    @NotNull
    private BigDecimal feeRate;

    /**
     * 返点金额
     */
    private BigDecimal rebateAmount;

    /**
     * 返点率
     */
    private BigDecimal rebateRate;

    /**
     * 到账金额
     */
    @NotNull
    private BigDecimal amountToTheAccount;

    /**
     * 身份证姓名
     */
    @NotEmpty
    private String idName;

    /**
     * 身份证号码
     */
    @NotEmpty
    private String idCard;

    /**
     * 提现方式; ALIPAY:支付宝, BANK:银行账户
     * @see OrderConstant.DictWithdrawalsWay
     */
    @NotEmpty
    private String withdrawalsWay;

    /**
     * 支付宝账户
     */
    private String alipayAccount;

    /**
     * 银行账户持卡人姓名
     */
    private String bankCardholderName;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行账户
     */
    private String bankAccount;

    /**
     * 收款人手机号码
     */
    private String payeeMobile;

    /**
     * 代理商编号
     */
    private String agentCode;

    /**
     * 合作客户编号
     */
    private String customerCode;

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;



    /**
     * 提现问券：问券答题试券编号
     */
    private String paperCode;

    /**
     * 提现问券：问券试券题目数量
     */
    private Integer questNum;


    /**
     * 结算账户编号,提现结算服务系统的编号
     * @see com.rocogz.syy.withdraw.entity.settle.SettleAccount#code
     */
    private String settleAcctCode;

}

