package com.rocogz.syy.order.entity.withdrawals;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.UserTimeEntity;
import com.rocogz.syy.order.constant.OrderConstant;
import com.rocogz.syy.order.constant.WithdrawHandleWayEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单中心-提现订单记录表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-08-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_withdrawals_record")
public class WithdrawalsRecord extends UserTimeEntity {

    private static final long serialVersionUID=1L;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 消耗的虚拟货币总金额,即提现消耗的积分值
     */
    private BigDecimal usedVirtualCurrencyAmount;

    /**
     * 手续费 = usedVirtualCurrencyAmount * feeRate
     */
    private BigDecimal feeAmount;

    /**
     * 费率
     */
    private BigDecimal feeRate;

    /**
     * 返点金额 =  rebateRate * usedVirtualCurrencyAmount
     */
    private BigDecimal rebateAmount;

    /**
     * 返点率
     */
    private BigDecimal rebateRate;

    /**
     * 是否已返点
     */
    private Boolean rebated;

    /**
     * 返点处理时间
     */
    private Boolean rebateProcessTime;

    /**
     * 返点处理业务单号
     */
    private String rebateProcessBusinessCode;

    /**
     * 到账金额 =  usedVirtualCurrencyAmount - feeAmount
     */
    private BigDecimal amountToTheAccount;

    /**
     * 身份证姓名
     * 提现方式是： ALIPAY时的 收款人姓名
     */
    private String idName;

    /**
     * 身份证号码
     */
    private String idCard;

    /**
     * 提现方式; ALIPAY:支付宝, BANK:银行账户
     * @see OrderConstant.DictWithdrawalsWay#BANK
     */
    private String withdrawalsWay;

    /**
     * 支付宝账户
     */
    private String alipayAccount;

    /**
     * 银行账户持卡人姓名,
     * withdrawalsWay提现方式是：BANK 时的 收款人姓名
     */
    private String bankCardholderName;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行账户
     */
    private String bankAccount;

    /**
     * 提现状态:
     *   1. 刚创建的提现订单状态,状态是 PENDING_PROCESS(待处理)
     *   2. 点击 "开始处理"按钮后, 变成 PROCESSING（处理中），此状态系统目前还可以修改收款人银行卡信息？
     *   3. SUCCESS-提现成功 （到银行卡提现 手工确认提现成功 按钮是否要删除吗）
     *   4. FAIL-提现失败 （到银行卡提现  手工确认提现失败 按钮是否要删除吗）
     * @see OrderConstant.DictWithdrawalsStatus
     */
    private String withdrawalsStatus;

    /**
     * 备注，可用于填写审核不通过、提现失败的原因
     */
    private String remark;

    /**
     * 当订单审核不通过或者提现失败时，用于记录是否成功回退了提现积分
     */
    private String isRollbackCouponSuccess;

    /**
     * 积分账户类型
     */
    private String pointType;

    /**
     * 收款人手机号码.
     */
    private String payeeMobile;


    /**
     * 问券答题试券编号
     */
    private String paperCode;

    /**
     * 问券试券题目数量
     */
    private Integer questNum;

    /**
     * 提现处理方式: 目前只有 提现到银行卡，并且关联了结算billCode的才使用"线上结算系统",其他的走人工处理
     */
    private WithdrawHandleWayEnum handleWay;


    // 下面是提现结算相关的字段 =====

    /**
     * 结算账户编号, 提现结算服务系统的结算账户编号
     * @see com.rocogz.syy.withdraw.entity.settle.SettleAccount#code
     */
    private String settleAcctCode;

    /**
     * 结算单编号，提现结算服务系统的结算单编号
     * @see com.rocogz.syy.withdraw.entity.settle.SettleBill#code
     */
    private String billCode;

    /**
     * 结算明细单号，提现结算服务系统的结算明细单号
     * @see com.rocogz.syy.withdraw.entity.settle.SettleBillOrderItem#itemCode
     */
    private String billOrderItemCode;


    /**
     * 提现预计到账时间
     *
     如果是工作日：
     <= 16:00的提现, 当天 20:00到账

     否则 16:00之后，下个工作日: 20:00点到账
     */
    @TableField(exist = false)
    private String  predictReceiptTime;

}
