package com.rocogz.syy.order.dto.goods;

import com.rocogz.syy.order.entity.orders.SaleOrder;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 查询浙商银行 客户未领取的实物 【商品订单】
 * @date 2023/07/25
 * @author zhangmin
 */
@Setter
@Getter
public class GoodOrderZsBankUnReceiveDto {

    /**
     * 发放主体编号
     * @see SaleOrder#issuingBodyCode
     */
    private String issuingBodyCode;

    /**
     * 创建人,也就是实物订单的下单人用户名，即发放清单的用户名
     */
    private String createUser;

    /**
     * 创建人名字,也就是实物订单的下单人姓名，即发放清单的创建人的姓名
     */
    private String createUserFullName;

    /**
     * 创建人手机号,也就是实物订单的下单人手机号，即发放清单的创建人的手机号
     */
    private String createUserMobile;


    /**
     * 实物订单编号
     * @see GoodsOrder#orderCode
     */
    private String orderCode;

    /**
     * 市场价
     * @see GoodsOrder#getAgentProductMarketPrice()
     */
    private BigDecimal marketPrice;


    /**
     * 商品编号
     * @see GoodsOrder#goodsCode
     */
    private String goodsCode;


    /**
     * 商品简称
     * @see GoodsOrder#goodsName
     */
    private String goodsName;


    /**
     * 商品图片
     * @see GoodsOrder#goodsPictureUrl
     */
    private String goodsPictureUrl;


    /**
     * 数量
     * @see GoodsOrder#goodsAmount
     */
    private Integer quantity;


    /**
     * 产品类别
     * @see GoodsOrder#productType
     * @see Constant.DictData#PRODUCT_TYPE_OIL_CARD_DIGITAL_YES
     */
    private String productType;

    /**
     * 是否虚拟商品
     * @see GoodsOrder#virtualGoods
     */
    private Boolean virtual;

}
