package com.rocogz.syy.order.dto.withdrawals;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 转让汇总Dto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/8/4 16:14</dd>
 * <dd>@author：ranxiangfu</dd>
 * </dl>
 */
@Setter
@Getter
@Accessors(chain = true)
public class WithdrawalsSummaryResultDto {

    /**
     * 用户帐户可用剩余积分余额
     */
    private BigDecimal virtualCurrencyTotalAmount = new BigDecimal(0);

    /**
     * 转让中金额，即：提现中总积分 =  sum(used_virtual_currency_amount) where withdrawals_status in ('PENDING', 'PENDING_PROCESS', 'PROCESSING')
     */
    private BigDecimal usingVirtualCurrencyTotalAmount = new BigDecimal(0);

    /**
     * 转让中到账金额，即：提现中到账金额：元（扣除手续费后的） =  sum(amount_to_the_account) where withdrawals_status in ('PENDING', 'PENDING_PROCESS', 'PROCESSING')
     */
    private BigDecimal processingWithdrawalAmount = new BigDecimal(0);

    /**
     * 正在提现中的订单数量: withdrawals_status in ('PENDING', 'PENDING_PROCESS', 'PROCESSING') 的订单数量
     */
    private Integer processingWithdrawalsOrderCount = 0;

    /**
     * 累计转让总额，扣除手续费后到账总金额，即：提现成功到账总金额(元) =  sum(amount_to_the_account) where withdrawals_status = 'SUCCESS'
     */
    private BigDecimal withdrawalsTotalAmount = new BigDecimal(0);
}
