/*
 * Decompiled with CFR 0.152.
 */
package com.rocogz.syy.order.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

public class DateTimeUtil {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATE_NO_DELIMITER_FORMAT = "yyyyMMdd";
    private static final String DATE_HOUR_FORMAT = "yyyy-MM-dd HH";
    private static final String DATE_HOUR_MINUTE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_TIME_NO_DELIMITER_FORMAT = "yyyyMMddHHmmss";
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_TIME_NO_DELIMITER_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final String TIME_DAY_START = " 00:00:00";
    public static final String TIME_DAY_END = " 23:59:59";

    private DateTimeUtil() {
    }

    public static LocalDate weekStart(int offset) {
        LocalDate localDate = LocalDate.now().plusWeeks(offset);
        return localDate.with(DayOfWeek.MONDAY);
    }

    public static LocalDate weekEnd(int offset) {
        LocalDate localDate = LocalDate.now().plusWeeks(offset);
        return localDate.with(DayOfWeek.SUNDAY);
    }

    public static LocalDate monthStart(int offset) {
        return LocalDate.now().plusMonths(offset).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate monthEnd(int offset) {
        return LocalDate.now().plusMonths(offset).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate quarterStart(int offset) {
        LocalDate date = LocalDate.now().plusMonths(offset * 3);
        int month = date.getMonth().getValue();
        int start = 0;
        start = month <= 3 ? 1 : (month <= 6 ? 4 : (month <= 9 ? 7 : 10));
        return date.plusMonths(start - month).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate quarterEnd(int offset) {
        LocalDate date = LocalDate.now().plusMonths(offset * 3);
        int month = date.getMonth().getValue();
        int end = 0;
        end = month <= 3 ? 3 : (month <= 6 ? 6 : (month <= 9 ? 9 : 12));
        return date.plusMonths(end - month).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate yearStart(int offset) {
        return LocalDate.now().plusYears(offset).with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDate yearEnd(int offset) {
        return LocalDate.now().plusYears(offset).with(TemporalAdjusters.lastDayOfYear());
    }
}

