package com.rocogz.syy.order.constant;

/**
 * 加油电子券订单 相关的 常量类
 * @author zhangmin
 * @date 2020/5/31
 */
public final class OilTicketOrderConstant {


    /**
     * 加油订单类型
     */
    public static class DictOilTicketType {

        //字典类型编号
        public static final String TYPE_CODE = "OIL_TICKET_TYPE";

        //=== 下面是字典值

        //纯 电子券兑换
        public static final String OIL_TICKET = "OIL_TICKET";

        /**
         * 代金券+现金支付 兑换，加油订单类型是该类型时：
         * com.rocogz.syy.order.entity.oil.OrderOilDeposit#depositAmt = VOUCHER(代金券) + 现金支付的钱
         */
        public static final String VOUCHER_WITH_CASH = "VOUCHER_WITH_CASH";

    }

    /**
     * 充值状态常量
     */
    public static class DictDepositStatus {
        //字典类型编号
        public static final String TYPE_CODE = "OIL_TICKET_DEPOSIT_STATUS";

        //=== 下面是字典值
        //待充值
        public static final String PENDING_DEPOSIT = "PENDING_DEPOSIT";

        //充值处理中
        public static final String PROCESSING = "PROCESSING";

        //充值完成
        public static final String FINISHED = "FINISHED";

        //充值失败
        public static final String FAILED = "FAILED";

    }



}
