package com.rocogz.syy.order.dto.goods;

import com.rocogz.syy.order.entity.goods.GoodsOrderDeliveryAddress;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * <dl>
 * <dd>Description: GoodsOrderReceiveDto</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@date：2020/8/29 15:41</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@Accessors(chain = true)
@Data
public class GoodsOrderZsBankReceiveDto {

    /**
     * 领取的所有的商品订单编号 【所有发放实物的】
     */
    private List<String> allGoodOrderCodes;

    /**
     * 会员编号 [必传]
     */
    @NotEmpty
    private String userCode;

    /**
     * 会员手机号
     */
    private String userMobile;

    /**
     * 会员openid [必传]
     */
    @NotEmpty
    private String openId;

    /**
     * 非虚拟实物订单的 收获地址
     */
    private GoodsOrderDeliveryAddress deliveryAddress;
}
