package com.rocogz.syy.order.dto.inspection;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 *  支付成功后,返回的对象
 * @author djt
 * @date 2021/01/22
 */
@Setter @Getter @Accessors(chain = true)
public class CarInspectionOrderPayedResultDto  {

    /**
     * 成功支付的 车服订单号
     */
    private String orderCode;

    /**
     * 会员编号
     */
    private String userCode;


    /**
     * 第三方支付平台的支付单号或支付交易号 [必须]
     */
    private String payCode;


    /**
     * 鼎聚权益编号
     */
    private String powerNo;

    /**
     * 支付的现金 金额 [必须]
     */
    private BigDecimal payAmt;

    /**
     * 现金支付方式：是微信支付,还是支付宝支付  [必须]
     * @see OrderConstant.DictPayWay#WEIXIN
     */
    private String payWay;

    /**
     * 本次支付 所使用的 核销码列表
     */
    private List<String> writeOffCodeList;

    /**
     * 要充值的金额 [必传]
     */
    private BigDecimal depositAmt;

    /**
     * 充值手机号【必传】
     */
    private String depositMobile;



    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 车辆类型
     */
    private String carType;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 商户订单号
     */
    private String outOrderId;

    /**
     * 预约年检日期(如：2020-02-19)
     */
    private LocalDate appointTime;

    /**
     * 客户姓名
     */
    private String consignee;

    /**
     * 取车地址(除自驾外都需填写)
     */
    private String userLoc;

    /**
     * 预约接车时间(除自驾外都需填写 如：2020-02-19 08:30:00)
     */
    private LocalDateTime userTime;


    /**
     * 行驶证正页
     */
    private String drivingLicense1;

    /**
     * 行驶证副页
     */
    private String drivingLicense2;

    /**
     * 检测站唯一标识
     */
    private String identify;

    /**
     * 检测站报价
     */
    private String price;

}
