package com.rocogz.syy.order.dto.withdrawals;

import com.rocogz.syy.order.entity.withdrawals.WithdrawalsFeeRateConfig;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * <dl>
 * <dd>Description: 按照身份证号 统计 已提现到账金额（用来判定是否超过限额） 月/年 汇总</dd>
 * <dd>Company: 大诚若谷信息技术有限公司</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@Setter
@Getter
@Accessors(chain = true)
public class WithdrawStatisAmtResultDto {

    /**
     * 发放主体编号
     */
    private String issuingBodyCode;

    /**
     * 身份证号
     */
    private String idNo;

    /**
     * 月 已提现到账金额 <br/>
     * sum(amount_to_the_account) where withdrawals_status not in ('REFUSE', 'FAIL') and id_card='身份证号' and issuing_body_code ='主体编号'
     */
    private BigDecimal monthWithdrawedAmt = new BigDecimal(0);

    /**
     * 年 已提现到账金额 <br/>
     * sum(amount_to_the_account） where withdrawals_status in ('REFUSE', 'FAIL') and id_card='身份证号' and issuing_body_code ='主体编号
     */
    private BigDecimal yearWithdrawedAmt = new BigDecimal(0);


    //发放主体 配置的 提现金额限制,如果发放主体 还没有设置提现费率,则获取全局默认的提现费率设置
    private WithdrawalsFeeRateConfig issuingBodyFeeRateCfg;


}
