package com.rocogz.syy.order.entity.peccancy;

import com.rocogz.syy.common.entity.IdEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 违章订单查询记录
 * </p>
 *
 * @author liangyongtong
 * @since 2020-07-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderPeccancyQueryRecord extends IdEntity {


    /**
     * 用户编号
     */
    private String userCode;

    /**
     * 车牌号
     */
    private String plateNumber;

    /**
     * 车辆性质； 1:个人车 2:单位车
     */
    private Integer carProperty;

    /**
     * 最近一次查询时间
     */
    private LocalDateTime lastestQueryTime;

    /**
     * 车架号后6位
     */
    private String frameNumber;

    /**
     * 发动机后6位
     */
    private String engineNumber;

    /**
     * 车辆类型
     */
    private String carType;
}
