package com.rocogz.syy.order.entity.withdrawals;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.rocogz.syy.common.entity.IdEntity;
import java.time.LocalDateTime;

import com.rocogz.syy.order.constant.OrderConstant;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

/**
 * <p>
 * 订单中心-提现费率设置表
 * </p>
 *
 * @author ranxiangfu
 * @since 2020-09-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("order_withdrawals_fee_rate_config")
public class WithdrawalsFeeRateConfig extends IdEntity {

    private static final long serialVersionUID=1L;

    /**
     * 用户手机号,默认提现费率时保存*
     */
    private String userMobile;

    /**
     * 提现费率: 0.03 表示提现费率是 3%
     */
    private BigDecimal feeRate;

    /**
     * 返点率,费率类型是主体 才有值
     */
    private BigDecimal rebateRate;

    /**
     * 姓名
     */
    private String name;

    /**
     * 公司
     */
    private String company;

    /**
     * 状态(OPEN:启用; LOCK:停用)
     * @see OrderConstant#COMMON_STATUS_OPEN
     */
    private String status;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 提现费率设置类型
     * @see OrderConstant.DictWithdrawalsFeeRateType
     */
    private String type;

    /**
     * 发放主体编码
     */
    private String issuingBodyCode;


    /**
     * 提现限制方式：按照身份证限制
     * @see OrderConstant.DictWithdrawFeeLimitWay
     */
    private String limitWay;


    /**
     * 身份证 每月提现金额限制（到账金额） 阈值, 默认10000
     * （1） NULL表示 不限制
     * （2）0表示 不允许提现
     */
    private BigDecimal monthLimit;

    /**
     * 身份证 每年的提现限制（到账金额） 阈值，默认20000
     * （1） NULL表示 不限制
     * （2）0表示 不允许提现
     */
    private BigDecimal yearLimit;

    /**
     * 发放主体简称
     */
    @TableField(exist = false)
    private String issuingBodyAbbreviation;


    //获取保存操作的日志的 code
    public String getLogCode() {
        if(StringUtils.isBlank(type)) {
            return "";
        }

        if(OrderConstant.DictWithdrawalsFeeRateType.ISSUING_BODY.equals(type)) {
            return issuingBodyCode;
        }


        //非主体类型费率
        if(StringUtils.isBlank(issuingBodyCode)) {
            return userMobile;
        }

        return userMobile +"_" + issuingBodyCode;
    }

}
