package com.rocogz.syy.order.constant;

/**
 * <dl>
 * <dd>Description:赠送礼品方案的常量 </dd>
 * <dd>@date: 2023/08/14</dd>
 * <dd>@author: huhailong</dd>
 * </dl>
 */
public class GivenGiftSchemeConstant {

    public static final String GIVEN_GIFT_SCHEME_OP_LOCK_PREFIX = "GIVEN_GIFT_SCHEME_OP_LOCK_PREFIX:";

    /**
     * 过期时间5天
     */
    public static final int SCHEME_INVALID_TIME_DAY = 5 ;

    /**
     * 赠送方案状态
     */
    public static class GivenGiftSchemeDictState {

        //字典类型编号
        public static final String TYPE_CODE = "GIVEN_GIFT_SCHEME_STATUS";
        /**
         * 待确认
         */
        public static final String WAIT_CONFIRM = "WAIT_CONFIRM";
        /**
         * 已确认
         */
        public static final String CONFIRMED = "CONFIRMED";
        /**
         * 处理中
         */
        public static final String IN_PROCESS = "IN_PROCESS";

        /** 处理状态：已作废 */
        public static final String VOID = "VOID";


        /** 已失效 **/
        public static final String INVALID = "INVALID";

        /** 处理状态：完成 */
        public static final String COMPLETED = "COMPLETED";

    }


    /**
     * 订单 操作动作,用来记录操作流水
     */
    public static final class GivenGiftSchemeActionDict {

        //字典类型编号
        public static final String TYPE_CODE = "GIVEN_GIFT_SCHEME_ACTION";

        //=== 下面是字典值

        //创建
        public static final String CREATE = "CREATE";

        //编辑
        public static final String EDIT = "EDIT";

        //确认
        public static final String CONFIRM = "CONFIRM";

        //提交申请
        public static final String SUBMIT_APPLY = "SUBMIT_APPLY";


        //申请失败：审核/审批或中止时
        public static final String APPLY_FAIL = "APPLY_FAIL";

        //逻辑删除
        public static final String DELETE = "DELETE";

        //完成 //清单已发放
        public static final String COMPLETE = "COMPLETE";

        //作废
        public static final String VOID = "VOID";

        //超时确认取消
        public static final String INVALID = "INVALID";

        //超时确认取消
        public static final String TO_SHARE = "TO_SHARE";


    }
}
