package com.rocogz.syy.order.constant;

/**
 * 支付记录 扩展属性常量
 * @author zhangmin
 * @date 2020/5/29
 */
public final class PayRecordExtAttrConstant {

    /**
     * 服务券类型的订单 支付扩展属性
     */
    public static class CouponOrderExtAttr {

        /**
         * 用户券来源车牌号
         */
        public static final String COUPON_CAR_LICENSE = "couponCarLicense";

        /**
         * 用户服务券的车架号
         */
        public static final String COUPON_CAR_VINNO = "couponCarVinNo";

        /**
         * 优惠券编号
         */
        public static final String COUPON_CODE = "couponCode";

        /**
         * 优惠券名称
         */
        public static final String  COUPON_NAME = "couponName";

        /**
         * 优惠券活动编号
         */
        public static final String COUPON_ACTIVITY_CODE =  "couponActivityCode";

        /**
         * 优惠券保单号
         */
        public static final String COUPON_POLICY_CODE = "couponPolicyCode";

        /**
         * 用户服务券 生效日期
         */
        public static final String COUPON_EFFECTIVE_DATE = "couponEffectiveDate";


        /**
         * 用户服务券的生效日期
         */
        public static final String COUPON_INVALID_DATE = "couponInvalidDate";



    }



    /**
     * 油卡充值订单 支付扩展属性
     */
    public static class OilOrderExtAttr {

        /**
         * 鼎聚权益编号
         */
        public static final String DINGJU_POWER_NO = "powerNo";


    }

}
