package com.rocogz.syy.order.dto;

import com.rocogz.syy.order.entity.goods.GoodsOrder;
import com.rocogz.syy.order.entity.withdrawals.WithdrawalsRecord;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 通过多个订单号获取订单信息，积分兑换订单导出功能使用
 * @author zhangmin
 */
@Setter @Getter
@Accessors(chain = true)
public class OrderInfoResultDto {

    private String orderCode;

    private String orderType;

    private String miniAppid;

    //合作客户编号
    private String customerCode;

    private String userMobile;


    // =======  商品订单类型如下：
    private String productType;


    //供应商编号
    private String supplierCode;

    /**
     * @see GoodsOrder#agentProductMarketPrice
     */
    private BigDecimal agentProductMarketPrice;

    /**
     * @see  GoodsOrder#goodsUnitPrice
     */
    private BigDecimal goodsUnitPrice;

    /**
     * @see GoodsOrder#goodsTotalPrice
     */
    private BigDecimal goodsTotalPrice;

    /**
     * @see GoodsOrder#goodsAmount
     */
    private Integer goodsAmount;


   // ===== 提现订单

    /**
     * @see WithdrawalsRecord#usedVirtualCurrencyAmount
     */
    private BigDecimal usedVirtualCurrencyAmount;

}
